---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-ビルド同期通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 75-85行目 - SyncMessage型
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 27行目 - SYNC enum
- E-03: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1103-1121行目 - Turbopack送信
- E-04: `packages/next/src/server/dev/hot-middleware.ts` 166-211行目 - Webpack送信
- E-05: `packages/next/src/server/dev/hot-middleware.ts` 55-71行目 - getStatsForSyncEvent
- E-06: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 819-824行目 - lazy版VersionInfo取得
- E-07: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 298-374行目 - App Router処理
- E-08: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` 293-341行目 - Pages Router処理
- E-09: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1099-1101行目 - devIndicator期限チェック
- E-10: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 309-316行目 - versionInfo/debug/devIndicator/devToolsConfig処理
- E-11: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1085-1097行目 - エラー収集
- E-12: `packages/next/src/server/dev/hot-middleware.ts` 183-211行目 - WebpackのonHMR同期処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SyncMessageはhash,errors,warnings,versionInfo等のフィールドを持つ | E-01 | ○ |
| C-02 | SYNCの値は`sync` | E-02 | ○ |
| C-03 | Turbopackでは接続時にsendToClientで送信 | E-03 | ○ |
| C-04 | Webpackでは接続時にpublishで送信 | E-04 | ○ |
| C-05 | Webpackではサーバーエラー時はサーバー統計を優先 | E-05 | ○ |
| C-06 | バージョン情報はlazy初期化 | E-06 | ○ |
| C-07 | App RouterでversionInfo等を処理 | E-07, E-10 | ○ |
| C-08 | Pages Routerでも同様に処理 | E-08 | ○ |
| C-09 | devIndicator期限チェックが送信前に実行 | E-09 | ○ |
| C-10 | エラー情報がcurrentEntryIssuesから収集される | E-11 | ○ |
| C-11 | SYNCはBUILTの上位互換（追加フィールドあり） | E-01 | ○ |
| C-12 | WebSocket統計情報なしの場合は送信スキップ | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] SyncMessageの全フィールドが正確に記載されているか確認
- [ ] Turbopack/Webpackそれぞれの送信タイミングが正確か確認
- [ ] バージョン情報取得のlazy初期化ロジックを確認
