---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-ビルド完了通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 87-93行目 - BuiltMessage型
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 28行目 - BUILT enum
- E-03: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1484-1537行目 - Turbopack end処理
- E-04: `packages/next/src/server/dev/hot-middleware.ts` 214-229行目 - Webpack publishStats
- E-05: `packages/next/src/server/dev/hot-middleware.ts` 113-117行目 - onClientDone
- E-06: `packages/next/src/server/dev/hot-middleware.ts` 127-133行目 - onServerDone
- E-07: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 298-374行目 - App Router BUILT処理
- E-08: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 370-372行目 - BUILTのみhandleHotUpdate
- E-09: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` 293-341行目 - Pages Router処理
- E-10: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1539-1545行目 - コンパイル時間出力
- E-11: `packages/next/src/client/dev/hot-reloader/turbopack-hot-reloader-common.ts` 100-124行目 - onBuilt()
- E-12: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1519-1537行目 - クライアント個別エラー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BuiltMessageはhash,errors,warnings,updatedModulesを持つ | E-01 | ○ |
| C-02 | BUILTの値は`built` | E-02 | ○ |
| C-03 | TurbopackではupdateType endで送信 | E-03 | ○ |
| C-04 | WebpackではpublishStatsで送信 | E-04 | ○ |
| C-05 | Webpack clientのdoneフックで発火 | E-05 | ○ |
| C-06 | Webpack serverのdoneフックはエラー時のみ | E-06 | ○ |
| C-07 | BUILTの場合のみhandleHotUpdate()が呼ばれる | E-08 | ○ |
| C-08 | TurbopackではクライアントごとにclientIssuesを含む | E-12 | ○ |
| C-09 | コンパイル時間ログ出力 | E-10 | ○ |
| C-10 | TurbopackHmr.onBuilt()でHMR更新判定 | E-11 | ○ |
| C-11 | App RouterのBUILT/SYNC共通処理 | E-07 | ○ |
| C-12 | Pages RouterのBUILT/SYNC共通処理 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] TurbopackのクライアントごとのBUILTメッセージ生成ロジックを確認
- [ ] BUILTの場合のみhandleHotUpdate()が呼ばれることを確認
- [ ] Webpack publishStatsのstats抽出が正確か確認
