---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-サーバーエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 95-98行目 - ServerErrorMessage型
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 30行目 - SERVER_ERROR enum
- E-03: `packages/next/src/server/dev/hot-reloader-webpack.ts` - send()メソッドでのSERVER_ERROR送信
- E-04: `packages/next/src/client/page-bootstrap.ts` 31-36行目 - page-bootstrap SERVER_ERROR処理
- E-05: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 454-462行目 - App Router処理
- E-06: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` 349-357行目 - Pages Router処理
- E-07: `packages/next/src/shared/lib/utils.ts` - DecodeError型定義
- E-08: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 456-459行目 - Errorオブジェクト再構築
- E-09: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 460行目 - handleErrors呼び出し
- E-10: `packages/next/src/client/page-bootstrap.ts` 35行目 - throwによるエラー伝播

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServerErrorMessageはtypeとerrorJSONフィールドを持つ | E-01 | ○ |
| C-02 | SERVER_ERRORの値は`serverError` | E-02 | ○ |
| C-03 | Webpackモードでページエラー時に送信される | E-03 | ○ |
| C-04 | page-bootstrapではthrowでエラーを伝播 | E-04, E-10 | ○ |
| C-05 | App RouterではhandleErrorsでエラーオーバーレイ表示 | E-05, E-09 | ○ |
| C-06 | Pages Routerでも同様にhandleErrors処理 | E-06 | ○ |
| C-07 | errorJSONにはmessageとstackが含まれる | E-08 | ○ |
| C-08 | クライアント側でJSON.parseしてErrorオブジェクトを再構築 | E-08 | ○ |
| C-09 | DecodeError時にSERVER_ERRORが送信される | E-03, E-07 | ○ |
| C-10 | Turbopackモードでは主にBUILTのerrorsで伝達 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ServerErrorMessage送信箇所がhot-reloader-webpack.ts内で正確か確認
- [ ] errorJSONのJSON.stringify/parseの対称性を確認
- [ ] page-bootstrap.tsのthrowがエラーバウンダリでキャッチされることを確認
