---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：20-ブラウザ表示エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **バイナリメッセージのエンコード方式詳細**：messages.tsのcreateBinaryHmrMessageData関数の具体的なバイナリフォーマットの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` - ErrorsToShowInBrowserMessage型定義
- E-02: `packages/next/src/server/dev/serialized-errors.ts` 7-11行目 - errorsRscStreamsByHtmlRequestIdマップ
- E-03: `packages/next/src/server/dev/serialized-errors.ts` 12-27行目 - sendSerializedErrorsToClient
- E-04: `packages/next/src/server/dev/serialized-errors.ts` 29-42行目 - sendSerializedErrorsToClientForHtmlRequest
- E-05: `packages/next/src/server/dev/serialized-errors.ts` 44-51行目 - setErrorsRscStreamForHtmlRequest
- E-06: `packages/next/src/server/dev/serialized-errors.ts` 39行目 - delete後の送信
- E-07: `packages/next/src/server/dev/serialized-errors.ts` 48-49行目 - TODOコメント
- E-08: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 514-536行目 - App Routerデシリアライズ
- E-09: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` 396-398行目 - Pages Router無視
- E-10: `packages/next/src/server/dev/messages.ts` - createBinaryHmrMessageData関数
- E-11: `packages/next/src/server/dev/hot-middleware.ts` 240-246行目 - publishToClientでバイナリ判定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ErrorsToShowInBrowserMessageはtype(数値)とserializedErrors(Uint8Array)を持つ | E-01 | ○ |
| C-02 | errorsRscStreamsByHtmlRequestIdでhtmlRequestIdごとに管理 | E-02 | ○ |
| C-03 | sendSerializedErrorsToClientでstreamToUint8Arrayしてバイナリ変換 | E-03 | ○ |
| C-04 | htmlRequestIdでストリームを検索し送信後にdelete | E-04, E-06 | ○ |
| C-05 | setErrorsRscStreamForHtmlRequestでストリーム登録 | E-05 | ○ |
| C-06 | タイムアウトクリーンアップ未実装（TODOコメント） | E-07 | ○ |
| C-07 | App RouterでcreateFromReadableStreamでデシリアライズ | E-08 | ○ |
| C-08 | Pages Routerでは無視される | E-09 | ○ |
| C-09 | createBinaryHmrMessageDataでバイナリメッセージ構築 | E-10 | ○ |
| C-10 | message.typeが数値型の場合にバイナリ送信 | E-11 | ○ |
| C-11 | findSourceMapURLがデシリアライズオプションで使用される | E-08 | ○ |
| C-12 | バイナリメッセージの先頭1バイトがメッセージタイプを表す | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12のバイナリフォーマットの具体的な仕様はmessages.tsのcreateBinaryHmrMessageData実装に依存するが、バイナリエンコード方式の詳細はコードの複雑さにより完全な検証が困難
  - 候補：messages.ts / hot-middleware.ts / Turbopackバイナリプロトコル仕様

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - バイナリメッセージフォーマットの詳細に根拠不足あり

## 6) レビュアーチェックリスト（最小）
- [ ] messages.tsのcreateBinaryHmrMessageDataの実装が記載通りのバイナリフォーマットか確認
- [ ] serialized-errors.tsのストリーム管理ライフサイクルが正確か確認
- [ ] App RouterでのcreateFromReadableStreamのデシリアライズが正しく動作するか確認
- [ ] Pages Routerでの無視ロジックが正確か確認
