---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：21-DevPagesManifest更新通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **Webpackモードでの同等処理**：setup-dev-bundlerの詳細コード未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 30行目 DEV_PAGES_MANIFEST_UPDATE enum定義
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 128-135行目 DevPagesManifestUpdateMessage型定義
- E-03: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 644-747行目 handleEntrypointsSubscription関数
- E-04: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 718-728行目 DEV_PAGES_MANIFEST_UPDATE送信処理
- E-05: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1125-1134行目 send()メソッド
- E-06: `packages/next/src/client/page-bootstrap.ts` 42-54行目 Pages Routerクライアント受信処理
- E-07: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 464-466行目 App Router no-op処理
- E-08: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 672-677行目 addedRoutes/removedRoutes算出

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージタイプは`devPagesManifestUpdate`文字列 | E-01 | ○ |
| C-02 | メッセージ構造は`type`と`data: [{ devPagesManifest: true }]` | E-02 | ○ |
| C-03 | ルート追加・削除検出時に送信される | E-03, E-04 | ○ |
| C-04 | `addedRoutes.length > 0 \|\| removedRoutes.length > 0`が送信条件 | E-04, E-08 | ○ |
| C-05 | `hotReloader.send()`で全クライアントにブロードキャスト | E-05 | ○ |
| C-06 | Pages Routerクライアントは`_devPagesManifest.json`をfetchする | E-06 | ○ |
| C-07 | fetchした結果を`window.__DEV_PAGES_MANIFEST`に格納する | E-06 | ○ |
| C-08 | fetch失敗時は`console.log`でエラー出力 | E-06 | ○ |
| C-09 | App Routerクライアントではno-opとして処理される | E-07 | ○ |
| C-10 | 本通知はローカル開発環境専用 | E-03 | ○ |
| C-11 | Webpackモードでも同等のメッセージが送信される | **根拠不足** | △ |
| C-12 | WebSocket切断時は再接続後SYNCメッセージで同期される | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- Webpackモードでの送信処理の詳細（`setup-dev-bundler.ts`および`on-demand-entry-handler`の具体的なコード行）
  - 候補：`packages/next/src/server/lib/router-utils/setup-dev-bundler.ts` / `packages/next/src/server/dev/on-demand-entry-handler.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メッセージ構造は型定義で明確に定義されている
- 0: 低リスク - 送信ロジックはソースコードで直接確認済み
- 1: 中リスク - Webpackモードでの同等処理はgrep結果のみで詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] `DevPagesManifestUpdateMessage`型定義とドキュメント記載のメッセージ構造が一致するか
- [ ] `handleEntrypointsSubscription`内の送信条件が正しく記載されているか
- [ ] Pages Routerクライアントのfetch先URL（`/_next/static/development/_devPagesManifest.json`）が正しいか
- [ ] Webpackモードでの同等処理の有無を`setup-dev-bundler.ts`で確認
