---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-Turbopack接続通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 33行目 TURBOPACK_CONNECTED enum定義
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 137-140行目 TurbopackConnectedMessage型定義
- E-03: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 142行目 sessionId生成
- E-04: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1079-1083行目 接続時メッセージ送信
- E-05: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 888-889行目 onHMR・handleUpgrade
- E-06: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 375-383行目 クライアント側受信

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージタイプは`turbopack-connected` | E-01 | ○ |
| C-02 | メッセージに`sessionId`(number型)が含まれる | E-02 | ○ |
| C-03 | sessionIdは`Math.floor(Number.MAX_SAFE_INTEGER * Math.random())`で生成 | E-03 | ○ |
| C-04 | WebSocket接続確立直後に送信される | E-04, E-05 | ○ |
| C-05 | ブロードキャストではなく個別クライアントへの送信 | E-04 | ○ |
| C-06 | sessionIdはサーバー起動時に1回だけ生成される | E-03 | ○ |
| C-07 | SYNCメッセージの前に送信される | E-04 | ○ |
| C-08 | App RouterではprocessTurbopackMessageを呼び出す | E-06 | ○ |
| C-09 | Pages Routerではno-opとして処理される | E-06 | ○ |
| C-10 | 本通知はローカル開発環境専用 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セッションIDの生成と送信は明確にコードで確認済み
- 0: 低リスク - メッセージ構造は型定義で厳密に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] `sessionId`の生成タイミング（サーバー起動時1回のみ）が正しいか確認
- [ ] `turbopack-connected`がSYNCより先に送信されることを確認
- [ ] Pages Routerクライアントでのno-op処理を確認
