---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：23-ISRマニフェスト通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **マニフェスト差分通知未実装の主張**：コードベース全体の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 34行目 ISR_MANIFEST enum定義
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 142-145行目 AppIsrManifestMessage型定義
- E-03: `packages/next/src/server/lib/router-server.ts` 852-869行目 onUpgradeコールバック内送信処理
- E-04: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 267-284行目 クライアント側受信処理
- E-05: `packages/next/src/server/lib/router-server.ts` 853行目 isLegacyClient条件判定

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージタイプは`isrManifest` | E-01 | ○ |
| C-02 | dataは`Record<string, boolean>` | E-02 | ○ |
| C-03 | レガシークライアントにのみ送信される | E-03, E-05 | ○ |
| C-04 | `development.service?.appIsrManifest \|\| {}`がデータソース | E-03 | ○ |
| C-05 | Cache Components有効時は送信されない | E-03, E-05 | ○ |
| C-06 | クライアントは`staticIndicatorState.appIsrManifest`に格納 | E-04 | ○ |
| C-07 | `dispatcher.onStaticIndicator()`で状態更新 | E-04 | ○ |
| C-08 | 静的/動的/pending の3状態で判定 | E-04 | ○ |
| C-09 | `__NEXT_DEV_INDICATOR`環境変数で条件チェック | E-04 | ○ |
| C-10 | マニフェスト未生成時は空オブジェクトをフォールバック | E-03 | ○ |
| C-11 | マニフェスト更新後の差分通知は未実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- マニフェスト差分通知の有無について、`dev-bundler-service.ts`の全体確認が必要
  - 候補：`packages/next/src/server/lib/dev-bundler-service.ts` / `packages/next/src/server/dev/turbopack-utils.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メッセージ構造と送信条件はコードで明確
- 1: 中リスク - マニフェスト差分通知の有無は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] `isLegacyClient`の判定ロジックが正しく記載されているか
- [ ] `appIsrManifest`の生成タイミングと更新タイミングを確認
- [ ] マニフェスト差分通知の実装有無を`dev-bundler-service.ts`で確認
