---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-キャッシュインジケーター通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/cache-indicator.tsx` 1-2行目 型定義
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 35行目 CACHE_INDICATOR enum
- E-03: `packages/next/src/server/dev/hot-reloader-types.ts` 176-179行目 CacheIndicatorMessage型
- E-04: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1156-1168行目 setCacheStatus
- E-05: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 902-914行目 接続時遅延送信
- E-06: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 510-512行目 受信処理
- E-07: `packages/next/src/next-devtools/dev-overlay/shared.ts` 365-366行目 reducer処理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージタイプは`cacheIndicator` | E-02 | ○ |
| C-02 | stateは`filling/filled/bypass/ready`の4値 | E-01 | ○ |
| C-03 | CacheIndicatorStateは`ServerCacheStatus \| 'disabled'` | E-01 | ○ |
| C-04 | setCacheStatusで個別クライアントへ送信 | E-04 | ○ |
| C-05 | 未接続時は`cacheStatusesByHtmlRequestId`に保存 | E-04 | ○ |
| C-06 | 接続確立時に保存された状態を送信 | E-05 | ○ |
| C-07 | 送信後に`cacheStatusesByHtmlRequestId`から削除 | E-05 | ○ |
| C-08 | レガシークライアントには送信されない | E-04, E-05 | ○ |
| C-09 | クライアントは`dispatcher.onCacheIndicator`を呼び出す | E-06 | ○ |
| C-10 | OverlayStateのcacheIndicatorが更新される | E-07 | ○ |
| C-11 | htmlRequestIdで個別クライアントを特定 | E-04 | ○ |
| C-12 | バイナリではなくJSONメッセージとして送信 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] `setCacheStatus`の呼び出し元（キャッシュ状態変化のトリガー）を確認
- [ ] Cache Components無効時のフォールバック動作を確認
- [ ] Webpackモードでの同等実装を確認
