---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-DevToolsコンフィグ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/shared.ts` 11-22行目 DevToolsConfig型定義
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 37行目 DEVTOOLS_CONFIG enum
- E-03: `packages/next/src/server/dev/hot-reloader-types.ts` 147-150行目 DevToolsConfigMessage型
- E-04: `packages/next/src/next-devtools/server/devtools-config-middleware.ts` 15-70行目 ミドルウェア実装
- E-05: `packages/next/src/next-devtools/server/devtools-config-middleware.ts` 72-84行目 getDevToolsConfig
- E-06: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 776-784行目 ミドルウェア登録
- E-07: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1107-1118行目 SYNCメッセージ
- E-08: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 467-469行目 受信処理
- E-09: `packages/next/src/next-devtools/dev-overlay/shared.ts` 484-509行目 reducer処理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージタイプは`devtoolsConfig` | E-02 | ○ |
| C-02 | DevToolsConfigにtheme/position/scale等が含まれる | E-01 | ○ |
| C-03 | POSTリクエストで設定更新時に送信 | E-04 | ○ |
| C-04 | SYNCメッセージの一部として接続時に送信 | E-07 | ○ |
| C-05 | 設定ファイルは`{distDir}/cache/next-devtools-config.json`に永続化 | E-04, E-05 | ○ |
| C-06 | Zodスキーマによるバリデーション | E-04 | ○ |
| C-07 | deepMergeで既存設定とマージ | E-04 | ○ |
| C-08 | sendUpdateSignalでhotReloader.sendを呼び出す | E-06 | ○ |
| C-09 | クライアントはdispatcher.onDevToolsConfigを呼び出す | E-08 | ○ |
| C-10 | reducerでOverlayStateの各設定値を更新 | E-09 | ○ |
| C-11 | エンドポイントは`/__nextjs_devtools_config` | E-04 | ○ |
| C-12 | POST以外は405エラー | E-04 | ○ |
| C-13 | JSON解析失敗時は400エラー | E-04 | ○ |
| C-14 | ファイル未存在時は空ファイルを新規作成 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] `devToolsConfigSchema`の具体的なバリデーションルールを確認
- [ ] `deepMerge`の動作（配列・ネストオブジェクトのマージ戦略）を確認
- [ ] 設定ファイルの初回作成時のディレクトリ自動作成を確認
