---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：26-Turbopackメッセージ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **TurbopackUpdate型の詳細構造**：SWCバインディング型の詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 31行目 TURBOPACK_MESSAGE enum
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 58-61行目 TurbopackMessage型
- E-03: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 521-537行目 sendTurbopackMessage
- E-04: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 590-628行目 subscribeToHmrEvents
- E-05: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 463-506行目 sendEnqueuedMessages
- E-06: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 507行目 debounce(2)
- E-07: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 384-396行目 受信処理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メッセージタイプは`turbopack-message` | E-01 | ○ |
| C-02 | dataは`TurbopackUpdate \| TurbopackUpdate[]` | E-02 | ○ |
| C-03 | diagnostics/issuesは空配列に置き換えられる | E-03 | ○ |
| C-04 | 2msデバウンスでバッチ送信 | E-06 | ○ |
| C-05 | コンパイルエラー中は送信遅延 | E-05 | ○ |
| C-06 | HMRイベント購読で`data.type !== 'issues'`の場合に送信 | E-04 | ○ |
| C-07 | HMR購読エラー時はReloadPageメッセージ送信 | E-04 | ○ |
| C-08 | App Routerクライアントで`turbopackHmr.onTurbopackMessage`呼び出し | E-07 | ○ |
| C-09 | ランタイムエラー時は`performFullReload`実行 | E-07 | ○ |
| C-10 | `dispatcher.onBeforeRefresh`→`onRefresh`の順で呼び出し | E-07 | ○ |
| C-11 | Pages Routerではno-opとして処理 | E-01 | ○ |
| C-12 | turbopackUpdates配列にpushしてバッチ化 | E-03, E-05 | ○ |
| C-13 | TurbopackUpdateの詳細構造（ChunkListUpdate等） | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- `TurbopackUpdate`型の詳細構造はSWCバインディング（Rust側）で定義されており、TypeScript型定義の詳細確認が必要
  - 候補：`packages/next/src/build/swc/types.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 送信ロジックは明確にコードで確認済み
- 1: 中リスク - TurbopackUpdate型の詳細構造はSWCバインディング依存

## 6) レビュアーチェックリスト（最小）
- [ ] `TurbopackUpdate`型の実際の構造を`build/swc/types.ts`で確認
- [ ] diagnostics/issues空配列化の影響範囲を確認
- [ ] デバウンス2msの妥当性を確認
