---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-Reactデバッグチャンク通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` 42行目 REACT_DEBUG_CHUNK enum (= 0)
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` 152-159行目 ReactDebugChunkMessage型
- E-03: `packages/next/src/server/dev/messages.ts` 27-52行目 createBinaryHmrMessageData REACT_DEBUG_CHUNKケース
- E-04: `packages/next/src/server/dev/debug-channel.ts` 17-57行目 connectReactDebugChannel
- E-05: `packages/next/src/server/dev/debug-channel.ts` 59-71行目 connectReactDebugChannelForHtmlRequest
- E-06: `packages/next/src/server/dev/debug-channel.ts` 74-81行目 setReactDebugChannelForHtmlRequest
- E-07: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 1171-1198行目 setReactDebugChannel
- E-08: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` 471-487行目 受信処理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バイナリメッセージ種別は0（REACT_DEBUG_CHUNK） | E-01 | ○ |
| C-02 | メッセージ構造: [種別][idLen][requestId][chunk] | E-03 | ○ |
| C-03 | requestIdが255バイト超過でInvariantError | E-03 | ○ |
| C-04 | chunk=nullがストリーム終了を示す | E-02, E-04 | ○ |
| C-05 | 128KBバッファリングでストリーミング | E-04 | ○ |
| C-06 | ストリームエラー時にconsole.error+終了シグナル | E-04 | ○ |
| C-07 | 接続済みクライアントには即座にストリーミング開始 | E-07 | ○ |
| C-08 | 未接続時はデバッグチャンネルを保存 | E-06, E-07 | ○ |
| C-09 | 接続時に保存チャンネルを接続 | E-05 | ○ |
| C-10 | HTMLリクエストとサブリクエストの判定ロジック | E-07 | ○ |
| C-11 | クライアントでgetOrCreateDebugChannelReadableWriterPairを使用 | E-08 | ○ |
| C-12 | クライアントでchunk有ならwriter.write、無ならwriter.close | E-08 | ○ |
| C-13 | onHMR内で接続時にconnectReactDebugChannelForHtmlRequestを呼び出し | E-07 | ○ |
| C-14 | タイムアウトクリーンアップは未実装（TODO） | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - バイナリエンコーディング仕様が明確
- 0: 低リスク - ストリーミングロジックが明確
- 1: 中リスク - クリーンアップのTODOが未実装（リソースリーク可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] バイナリメッセージのエンコーディング仕様が正しいか確認
- [ ] 128KBバッファリングの妥当性を確認
- [ ] 未接続時のデバッグチャンネル保存のクリーンアップ（メモリリーク）を確認
