---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-コンパイル中通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/output/store.ts` 6行目 MAX_LOG_SKIP_DURATION_MS定数
- E-02: `packages/next/src/build/output/store.ts` 8-34行目 OutputState型定義
- E-03: `packages/next/src/build/output/store.ts` 36-47行目 formatTrigger関数
- E-04: `packages/next/src/build/output/store.ts` 84-131行目 storeサブスクリプション（loading分岐）
- E-05: `packages/next/src/build/output/store.ts` 111-123行目 setTimeoutによるタイマー設定
- E-06: `packages/next/src/build/output/store.ts` 174-186行目 コンパイル完了時のclearTimeout
- E-07: `packages/next/src/build/output/store.ts` 91行目 logging無効判定
- E-08: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 413-444行目 startBuilding関数

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3秒（3000ms）の遅延タイマー | E-01, E-05 | ○ |
| C-02 | メッセージ形式は`"Compiling {trigger} ..."` | E-05 | ○ |
| C-03 | NEXT_TRIGGER_URL設定時はURL付き形式 | E-05 | ○ |
| C-04 | `trigger === 'initial'`の場合はタイマー設定しない | E-04 | ○ |
| C-05 | `loadingLogTimer`が未設定の場合のみタイマー設定 | E-05 | ○ |
| C-06 | コンパイル完了時にclearTimeoutでキャンセル | E-06 | ○ |
| C-07 | `formatTrigger`で`__metadata_id__`を`[id]`に変換 | E-03 | ○ |
| C-08 | `formatTrigger`で末尾スラッシュを除去 | E-03 | ○ |
| C-09 | `logging`が無効の場合は出力しない | E-07 | ○ |
| C-10 | `bootstrap`状態の場合は出力しない | E-04 | ○ |
| C-11 | `hasStoreChanged`で状態変化を検出 | E-04 | ○ |
| C-12 | `trace('compile-path')`でトレーシング | E-04 | ○ |
| C-13 | `startBuilding`がconsoleStore.setStateを呼び出す | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ロジックがstore.ts内で完結しており明確

## 6) レビュアーチェックリスト（最小）
- [ ] `MAX_LOG_SKIP_DURATION_MS`の値（3000ms）が妥当か確認
- [ ] `formatTrigger`のメタデータルート整形が正しいか確認
- [ ] `loadingLogTimer`のタイマー管理にメモリリークがないか確認
