---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：30-コンパイルエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **consoleStore.setStateの呼び出し元の網羅性**：Turbopackモード以外の呼び出し元未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/output/store.ts` 8-34行目 OutputState型定義
- E-02: `packages/next/src/build/output/store.ts` 133-141行目 errors処理
- E-03: `packages/next/src/build/output/store.ts` 84行目 store.subscribe
- E-04: `packages/next/src/build/output/store.ts` 91行目 logging判定
- E-05: `packages/next/src/build/output/store.ts` 99行目 bootstrap判定
- E-06: `packages/next/src/server/dev/hot-reloader-turbopack.ts` 413-444行目 startBuilding

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | `state.errors[0]`で最初のエラーのみ出力 | E-02 | ○ |
| C-02 | `Log.error()`で出力 | E-02 | ○ |
| C-03 | エラー発生時に`startTime = 0`でリセット | E-02 | ○ |
| C-04 | `flushAllTraces()`と`teardownTraceSubscriber()`を呼び出し | E-02 | ○ |
| C-05 | `logging === false`の場合は出力抑止 | E-04 | ○ |
| C-06 | `bootstrap === true`の場合は出力抑止 | E-05 | ○ |
| C-07 | `hasStoreChanged`で状態変化を検出 | E-03 | ○ |
| C-08 | `state.loading === true`の場合はエラー出力しない | E-03 | ○ |
| C-09 | errorsはstring[]型 | E-01 | ○ |
| C-10 | ブラウザ側ではBUILT/SYNCメッセージでもエラーが送信される | E-01 | ○ |
| C-11 | WebpackモードでのconsoleStore.setState呼び出し元 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Webpackモードでの`consoleStore.setState`呼び出し元の詳細
  - 候補：`packages/next/src/build/output/index.ts` / `packages/next/src/server/dev/hot-reloader-webpack.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エラー出力ロジックは明確
- 1: 中リスク - Webpackモードでのエラー状態設定の詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] `state.errors[0]`のみ出力で十分か（複数エラーの表示要件）
- [ ] Webpackモードでの`consoleStore.setState`呼び出しを確認
- [ ] `flushAllTraces`/`teardownTraceSubscriber`のクリーンアップが適切か確認
