---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：31-コンパイル警告通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/output/store.ts` 行8-34（OutputState型定義）
- E-02: `packages/next/src/build/output/store.ts` 行84-191（storeサブスクリプション）
- E-03: `packages/next/src/build/output/store.ts` 行159-164（warnings出力処理）
- E-04: `packages/next/src/build/output/log.ts` 行7（warnプレフィックス定義）
- E-05: `packages/next/src/build/output/log.ts` 行57-59（warn関数）
- E-06: `packages/next/src/build/output/log.ts` 行20-43（prefixedLog関数）
- E-07: `packages/next/src/build/output/store.ts` 行62-75（hasStoreChanged関数）
- E-08: `packages/next/src/build/output/store.ts` 行91-93（logging抑止チェック）
- E-09: `packages/next/src/build/output/store.ts` 行99-101（bootstrap抑止チェック）
- E-10: `packages/next/src/build/output/store.ts` 行133-142（errors優先チェック）
- E-11: `packages/next/src/build/output/store.ts` 行6（MAX_LOG_SKIP_DURATION_MS定数）
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 行32（通知No.31定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OutputStateにwarningsフィールドが存在する | E-01 | ○ |
| C-02 | storeサブスクリプションで状態変更を監視する | E-02 | ○ |
| C-03 | warnings存在時にLog.warn()で出力する | E-03 | ○ |
| C-04 | 警告プレフィックスは黄色太字の⚠ | E-04 | ○ |
| C-05 | warn関数はprefixedLogを呼び出す | E-05 | ○ |
| C-06 | prefixedLogはconsole.warnを使用する | E-06 | ○ |
| C-07 | hasStoreChangedで重複出力を防ぐ | E-07 | ○ |
| C-08 | logging無効時は出力しない | E-08 | ○ |
| C-09 | bootstrap中は出力しない | E-09 | ○ |
| C-10 | errors存在時はエラー出力が優先される | E-10 | ○ |
| C-11 | 警告メッセージは\n\nで結合される | E-03 | ○ |
| C-12 | 出力後にflushAllTracesとteardownTraceSubscriberが呼ばれる | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全項目がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接根拠付けされている

## 6) レビュアーチェックリスト（最小）
- [ ] store.tsのstoreサブスクリプション内の条件分岐順序が設計書と一致しているか確認
- [ ] Log.warn()の出力形式（プレフィックス、改行結合）が設計書と一致しているか確認
