---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-型チェック中通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/output/store.ts` 行8-34（OutputState型定義、typeCheckingフィールド）
- E-02: `packages/next/src/build/output/store.ts` 行167-172（typeChecking判定とLog.info出力）
- E-03: `packages/next/src/build/output/store.ts` 行144-152（timeMessage計算ロジック）
- E-04: `packages/next/src/build/output/store.ts` 行154-157（modulesMessage計算ロジック）
- E-05: `packages/next/src/build/output/store.ts` 行36-47（formatTrigger関数）
- E-06: `packages/next/src/build/output/log.ts` 行65-67（info関数）
- E-07: `packages/next/src/build/output/log.ts` 行9（infoプレフィックス定義）
- E-08: `packages/next/src/build/output/log.ts` 行20-43（prefixedLog関数）
- E-09: `packages/next/src/build/output/store.ts` 行84（storeサブスクリプション）
- E-10: `packages/next/src/build/output/store.ts` 行91-93（logging抑止チェック）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行33（通知No.32定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | typeCheckingフラグがOutputStateに存在する | E-01 | ○ |
| C-02 | typeCheckingがtrueの場合にLog.infoで出力する | E-02 | ○ |
| C-03 | 所要時間は2秒超で秒表示、以下でms表示 | E-03 | ○ |
| C-04 | モジュール数はtotalModulesCountから取得 | E-04 | ○ |
| C-05 | formatTriggerで動的ルートを簡略化する | E-05 | ○ |
| C-06 | Log.infoはprefixedLog('info')を呼ぶ | E-06 | ○ |
| C-07 | infoプレフィックスは白太字スペース | E-07 | ○ |
| C-08 | prefixedLogはconsole.logを使用する | E-08 | ○ |
| C-09 | storeサブスクリプションで監視する | E-09 | ○ |
| C-10 | logging無効時は出力しない | E-10 | ○ |
| C-11 | 出力メッセージ形式は「bundled {trigger}{time}{modules}, type checking...」 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全項目がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接根拠付けされている

## 6) レビュアーチェックリスト（最小）
- [ ] store.tsの条件分岐でtypeChecking判定が警告チェックの後に来ることを確認
- [ ] timeMessageとmodulesMessageの計算ロジックが設計書と一致しているか確認
