---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-ランタイムエラーオーバーレイ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行584-788（Errorsコンポーネント）
- E-02: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行435-453（getErrorTypeLabel関数）
- E-03: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行455-481（ErrorDetails型定義）
- E-04: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行46-63（GenericErrorDescription）
- E-05: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行693-697（isServerError判定）
- E-06: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行617-678（generateErrorInfo関数）
- E-07: `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay/error-overlay.tsx` 行24-87（ErrorOverlay）
- E-08: `packages/next/src/next-devtools/dev-overlay/container/runtime-error/index.tsx` 行15-46（RuntimeError）
- E-09: `packages/next/src/next-devtools/dev-overlay/components/errors/error-overlay-layout/error-overlay-layout.tsx` 行58-180（ErrorOverlayLayout）
- E-10: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行701-760（errorDetailsによる分岐）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行35（通知No.34定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Errorsコンポーネントがランタイムエラー表示を担当する | E-01 | ○ |
| C-02 | getErrorTypeLabelで4種類のエラーラベルを決定する | E-02 | ○ |
| C-03 | ErrorDetailsは4種類（empty/hydration/blocking-route/dynamic-metadata） | E-03 | ○ |
| C-04 | 環境名プレフィックスがメッセージから除去される | E-04 | ○ |
| C-05 | サーバーサイドエラーの場合は閉じるボタンが無効化される | E-05 | ○ |
| C-06 | generateErrorInfoでMarkdown形式のエラー情報を生成する | E-06 | ○ |
| C-07 | ビルドエラーがランタイムエラーに優先する | E-07 | ○ |
| C-08 | RuntimeErrorコンポーネントでCodeFrameとCallStackを表示する | E-08 | ○ |
| C-09 | ErrorOverlayLayoutで全体レイアウトを構築する | E-09 | ○ |
| C-10 | errorDetailsに応じてエラーメッセージ表示を切り替える | E-10 | ○ |
| C-11 | 複数エラーのナビゲーション機能がある | E-01, E-09 | ○ |
| C-12 | useFramesでスタックフレームを取得する | E-01 | ○ |
| C-13 | 最初のファーストパーティフレームを特定してコードフレーム表示する | E-01, E-08 | ○ |
| C-14 | isLoadingの場合はOverlayBackdropのみ表示する | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全項目がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接根拠付けされている

## 6) レビュアーチェックリスト（最小）
- [ ] ErrorsコンポーネントのerrorDetails分岐ロジックが設計書と一致しているか確認
- [ ] getErrorTypeLabelの返却値パターンが設計書の記載と一致しているか確認
- [ ] サーバーエラー判定（getErrorSource）が正しく動作しているか確認
