---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-ハイドレーションエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/shared/react-19-hydration-error.ts` 行1-4（定数定義）
- E-02: `packages/next/src/next-devtools/shared/react-19-hydration-error.ts` 行9-14（正規表現パターン）
- E-03: `packages/next/src/next-devtools/shared/react-19-hydration-error.ts` 行16-26（isHydrationError関数）
- E-04: `packages/next/src/next-devtools/shared/react-19-hydration-error.ts` 行32-79（getHydrationErrorStackInfo関数）
- E-05: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行465-470（HydrationErrorDetails型）
- E-06: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行487-511（useErrorDetailsフック）
- E-07: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行513-543（getHydrationErrorDetails関数）
- E-08: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行42-44（HydrationErrorDescription）
- E-09: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行702-741（case 'hydration'分岐）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行36（通知No.35定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isHydrationErrorで正規表現パターンマッチにより判定する | E-02, E-03 | ○ |
| C-02 | getHydrationErrorStackInfoでメッセージ・差分・ノートを抽出する | E-04 | ○ |
| C-03 | HydrationErrorDetailsにwarning/notes/reactOutputComponentDiffフィールドがある | E-05 | ○ |
| C-04 | useErrorDetailsでハイドレーションエラー判定が最初に行われる | E-06 | ○ |
| C-05 | Pages Router用とApp Router用の2つの判定経路がある | E-07 | ○ |
| C-06 | HydrationErrorDescriptionでメッセージを表示する | E-08 | ○ |
| C-07 | reactOutputComponentDiff存在時にPseudoHtmlDiffを表示する | E-09 | ○ |
| C-08 | NEXTJS_HYDRATION_ERROR_LINKがドキュメントリンクとして表示される | E-01, E-09 | ○ |
| C-09 | React 19+ではコンポーネントスタック差分がエラーメッセージに含まれる | E-02 | ○ |
| C-10 | REACT_HYDRATION_ERROR_LINKで差分情報を区切って抽出する | E-04 | ○ |
| C-11 | ハイドレーションエラーでない場合は通常のランタイムエラー表示となる | E-06 | ○ |
| C-12 | 6種類の正規表現パターンでハイドレーションエラーを判定する | E-02, E-03 | ○ |
| C-13 | notes情報がある場合に追加表示される | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全項目がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接根拠付けされている

## 6) レビュアーチェックリスト（最小）
- [ ] isHydrationErrorの正規表現パターンが最新のReactエラーメッセージと一致しているか確認
- [ ] getHydrationErrorStackInfoのメッセージ解析ロジックが正確か確認
- [ ] Pages RouterとApp Routerの両方の経路が正しく動作しているか確認
