---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-ブロッキングルートエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行472-476（BlockingRouteErrorDetails型）
- E-02: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行545-582（getBlockingRouteErrorDetails関数）
- E-03: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行162-433（BlockingPageLoadErrorDescription）
- E-04: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行435-442（getErrorTypeLabel - Blocking Route判定）
- E-05: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行546（/blocking-routeパターン判定）
- E-06: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行549（cookies()によるvariant判定）
- E-07: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行569-579（/next-prerender-dynamic-viewportパターン）
- E-08: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行354-393（variant=runtime説明）
- E-09: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行394-432（variant=navigation説明）
- E-10: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行169-259（generateViewport分岐）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行37（通知No.36定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BlockingRouteErrorDetailsにtype/variant/refinementフィールドがある | E-01 | ○ |
| C-02 | /blocking-routeパターンでブロッキングルートエラーを検出する | E-05 | ○ |
| C-03 | cookies()の有無でruntime/navigationバリアントを判定する | E-06 | ○ |
| C-04 | /next-prerender-dynamic-viewportパターンでgenerateViewportエラーを検出する | E-07 | ○ |
| C-05 | エラー種別ラベルが「Blocking Route」に設定される | E-04 | ○ |
| C-06 | variant=runtimeの場合Suspense外のランタイムデータアクセスの説明が表示される | E-08 | ○ |
| C-07 | variant=navigationの場合ナビゲーションブロッキングの説明が表示される | E-09 | ○ |
| C-08 | generateViewportリファインメントの場合は専用の説明が表示される | E-10 | ○ |
| C-09 | 修正方法としてSuspenseの追加とuse cacheの使用が案内される | E-08, E-09 | ○ |
| C-10 | ドキュメントリンクがhttps://nextjs.org/docs/messages/blocking-route | E-08, E-09 | ○ |
| C-11 | 4つのvariant x refinementの組み合わせに応じた説明を表示する | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全項目がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接根拠付けされている

## 6) レビュアーチェックリスト（最小）
- [ ] getBlockingRouteErrorDetailsのパターンマッチ順序が正しいか確認
- [ ] BlockingPageLoadErrorDescriptionの4パターンの説明内容が正確か確認
