---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-動的メタデータエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行478-481（DynamicMetadataErrorDetails型）
- E-02: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行558-567（/next-prerender-dynamic-metadata判定）
- E-03: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行562（cookies()によるvariant判定）
- E-04: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行65-160（DynamicMetadataErrorDescription）
- E-05: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行443-445（getErrorTypeLabel - Ambiguous Metadata判定）
- E-06: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行70-113（variant=navigation説明）
- E-07: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行114-159（variant=runtime説明）
- E-08: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行108-110（ドキュメントリンク）
- E-09: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行750-753（case 'dynamic-metadata'分岐）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 行38（通知No.37定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DynamicMetadataErrorDetailsにtype/variantフィールドがある | E-01 | ○ |
| C-02 | /next-prerender-dynamic-metadataパターンで検出する | E-02 | ○ |
| C-03 | cookies()の有無でruntime/navigationバリアントを判定する | E-03 | ○ |
| C-04 | DynamicMetadataErrorDescriptionで説明を表示する | E-04 | ○ |
| C-05 | エラー種別ラベルが「Ambiguous Metadata」に設定される | E-05 | ○ |
| C-06 | variant=navigationの場合ナビゲーションブロッキングの説明が表示される | E-06 | ○ |
| C-07 | variant=runtimeの場合ランタイムデータアクセスの説明が表示される | E-07 | ○ |
| C-08 | ドキュメントリンクがhttps://nextjs.org/docs/messages/next-prerender-dynamic-metadata | E-08 | ○ |
| C-09 | Errorsコンポーネントのswitch文でcase 'dynamic-metadata'として処理される | E-09 | ○ |
| C-10 | 修正方法としてuse cacheへの移動とconnection()+Suspenseの追加が案内される | E-06, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全項目がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接根拠付けされている

## 6) レビュアーチェックリスト（最小）
- [ ] getBlockingRouteErrorDetails内の/next-prerender-dynamic-metadata判定順序が正しいか確認
- [ ] DynamicMetadataErrorDescriptionの2パターンの説明内容が正確か確認
