---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-バージョン古さ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/parse-version-info.ts` 行3-14（VersionInfoインターフェース）
- E-02: `packages/next/src/server/dev/parse-version-info.ts` 行16-69（parseVersionInfo関数）
- E-03: `packages/next/src/server/dev/parse-version-info.ts` 行26-28（stale-major判定）
- E-04: `packages/next/src/server/dev/parse-version-info.ts` 行30-38（stale-prerelease判定）
- E-05: `packages/next/src/server/dev/parse-version-info.ts` 行39-52（stale-patch/stale-minor判定）
- E-06: `packages/next/src/server/dev/parse-version-info.ts` 行53-58（newer-than-npm判定）
- E-07: `packages/next/src/server/dev/parse-version-info.ts` 行64-68（unknown判定）
- E-08: `packages/next/src/next-devtools/shared/version-staleness.ts` 行3-42（getStaleness関数）
- E-09: `packages/next/src/next-devtools/dev-overlay/components/version-staleness-info/version-staleness-info.tsx` 行6-51（VersionStalenessInfoコンポーネント）
- E-10: `packages/next/src/next-devtools/dev-overlay/components/version-staleness-info/version-staleness-info.tsx` 行18（stale判定でリンク表示）
- E-11: `packages/next/src/next-devtools/dev-overlay/components/version-staleness-info/version-staleness-info.tsx` 行53-114（スタイル定義）
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 行39（通知No.38定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VersionInfoにinstalled/staleness/expectedフィールドがある | E-01 | ○ |
| C-02 | parseVersionInfoでsemverを使ったバージョン比較を行う | E-02 | ○ |
| C-03 | stale-majorはメジャーバージョンが古い場合 | E-03 | ○ |
| C-04 | stale-prereleaseはcanaryバージョンが古い場合 | E-04 | ○ |
| C-05 | stale-patch/stale-minorはパッチ/マイナーが古い場合 | E-05 | ○ |
| C-06 | newer-than-npmはインストール版がnpmより新しい場合 | E-06 | ○ |
| C-07 | バージョン解析失敗時はunknownを返す | E-07 | ○ |
| C-08 | getStalenesで5パターンのtext/title/indicatorClassを生成する | E-08 | ○ |
| C-09 | stale系の場合はリンクとして表示される | E-10 | ○ |
| C-10 | Turbopackの場合はグラデーションテキストで表示される | E-11 | ○ |
| C-11 | EclipseIconの色はfresh/stale/outdated/unknownの4クラス | E-11 | ○ |
| C-12 | リンク先はhttps://nextjs.org/docs/messages/version-staleness | E-09 | ○ |
| C-13 | バンドラー名としてWebpack/Turbopack/Rspackをサポートする | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全項目がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接根拠付けされている

## 6) レビュアーチェックリスト（最小）
- [ ] parseVersionInfoのバージョン比較ロジック（判定優先順序）が設計書と一致しているか確認
- [ ] getStalenesの各ステータスに対応するtext/title/indicatorClassが正確か確認
