---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-Toastメッセージ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` 行3-7（ToastProps型定義）
- E-02: `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` 行9-27（Toastコンポーネント実装）
- E-03: `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` 行9（React.forwardRef使用）
- E-04: `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` 行15-16（closest('a')チェック）
- E-05: `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` 行19（onClick?.()呼び出し）
- E-06: `packages/next/src/next-devtools/dev-overlay/components/toast/toast.tsx` 行21（cx関数によるクラス結合）
- E-07: `packages/next/src/next-devtools/dev-overlay/container/errors.tsx` 行810-833（Toast関連CSSスタイル）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 行40（通知No.39定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToastPropsはHTMLProps<HTMLDivElement>を拡張する | E-01 | ○ |
| C-02 | React.forwardRefで外部からのref受け取りが可能 | E-03 | ○ |
| C-03 | closest('a')チェックでリンク内クリックを判定する | E-04 | ○ |
| C-04 | リンク以外のクリックでpreventDefaultを呼ぶ | E-04 | ○ |
| C-05 | onClick?.()でオプショナルにコールバックを実行する | E-05 | ○ |
| C-06 | cx('nextjs-toast', className)でCSSクラスを結合する | E-06 | ○ |
| C-07 | Toast関連のCSSスタイルがerrors.tsxに定義されている | E-07 | ○ |
| C-08 | Toastは状態管理を持たない汎用コンテナである | E-02 | ○ |
| C-09 | childrenに渡されたReactノードがそのまま表示される | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全項目がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接根拠付けされている

## 6) レビュアーチェックリスト（最小）
- [ ] Toastコンポーネントのクリックハンドラロジックが設計書と一致しているか確認
- [ ] Toast関連CSSスタイルの適用範囲が正確か確認
