---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-Turbopack未対応設定警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/turbopack-warning.ts` - unsupportedTurbopackNextConfigOptions配列（行5-39）
- E-02: `packages/next/src/lib/turbopack-warning.ts` - validateTurboNextConfig関数（行42-191）
- E-03: `packages/next/src/server/lib/start-server.ts` - 行478-483での呼び出し
- E-04: `packages/next/src/build/turbopack-build/impl.ts` - 行31での呼び出し
- E-05: `packages/next/src/build/turbopack-analyze/index.ts` - 行28での呼び出し

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 未サポートオプションリストはハードコードされた配列で管理されている | E-01（行5-39） | ○ |
| C-02 | flattenKeysでネスト設定をフラット化する | E-02（行79-102） | ○ |
| C-03 | デフォルト値と同一の場合は未サポートとみなさない | E-02（行134） | ○ |
| C-04 | 設定読み込みエラー時にLog.errorで出力して処理続行 | E-02（行140-142） | ○ |
| C-05 | 未サポート設定がある場合にLog.errorで一覧出力 | E-02（行169-179） | ○ |
| C-06 | Log.warnでTurbopack設定ドキュメントURLを出力 | E-02（行182-188） | ○ |
| C-07 | 開発サーバー起動時にTURBOPACK環境変数で条件判定 | E-03（行478） | ○ |
| C-08 | ビルド時にturbopack-build/impl.tsから呼び出される | E-04（行31） | ○ |
| C-09 | turbopack-analyze/index.tsからも呼び出される | E-05（行28） | ○ |
| C-10 | この通知はプロセスを終了させない | E-02（行169-191、process.exitなし） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードで確認可能であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] `unsupportedTurbopackNextConfigOptions`のリストが最新のソースコードと一致するか確認
- [ ] デフォルト値との比較ロジックが正しいか確認
