---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-App Routerルートアナウンサー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/app-router-announcer.tsx` 行5-6（定数定義）
- E-02: `packages/next/src/client/components/app-router-announcer.tsx` 行8-28（getAnnouncerNode関数）
- E-03: `packages/next/src/client/components/app-router-announcer.tsx` 行16-17（ariaLive, role設定）
- E-04: `packages/next/src/client/components/app-router-announcer.tsx` 行19-20（CSSオフスクリーン設定）
- E-05: `packages/next/src/client/components/app-router-announcer.tsx` 行23-24（Shadow DOM作成）
- E-06: `packages/next/src/client/components/app-router-announcer.tsx` 行30（AppRouterAnnouncerコンポーネント定義）
- E-07: `packages/next/src/client/components/app-router-announcer.tsx` 行33-42（初期化useEffect）
- E-08: `packages/next/src/client/components/app-router-announcer.tsx` 行47-67（タイトル検出useEffect）
- E-09: `packages/next/src/client/components/app-router-announcer.tsx` 行49-50（document.title取得）
- E-10: `packages/next/src/client/components/app-router-announcer.tsx` 行52-54（h1テキスト取得）
- E-11: `packages/next/src/client/components/app-router-announcer.tsx` 行60-62（初回ロード除外ロジック）
- E-12: `packages/next/src/client/components/app-router-announcer.tsx` 行69（createPortal使用）
- E-13: `packages/next/src/client/components/app-router-announcer.tsx` 行9-11（既存要素の再利用）
- E-14: `docs/code-to-docs/通知一覧/通知一覧.csv` 行41（通知No.40定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カスタム要素next-route-announcerを使用する | E-01 | ○ |
| C-02 | getAnnouncerNodeで既存要素を再利用する | E-13 | ○ |
| C-03 | aria-live="assertive"とrole="alert"を設定する | E-03 | ○ |
| C-04 | CSSで完全にオフスクリーン化する | E-04 | ○ |
| C-05 | Shadow DOMでDOMのカプセル化を実現する | E-05 | ○ |
| C-06 | tree propの変更でuseEffectが発火する | E-08 | ○ |
| C-07 | document.titleを優先的に取得する | E-09 | ○ |
| C-08 | タイトルがなければh1テキストを取得する | E-10 | ○ |
| C-09 | 初回ロードではアナウンスしない | E-11 | ○ |
| C-10 | タイトルが変更された場合のみアナウンスする | E-11 | ○ |
| C-11 | createPortalでアナウンサーノードにテキストを注入する | E-12 | ○ |
| C-12 | コンポーネントアンマウント時にDOM要素を削除する | E-07 | ○ |
| C-13 | FlightRouterStateがuseEffectの依存配列に含まれる | E-08 | ○ |
| C-14 | 本番ビルドにも含まれるアクセシビリティ機能である | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全項目がソースコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接根拠付けされている

## 6) レビュアーチェックリスト（最小）
- [ ] aria-live属性の値（assertive）がアクセシビリティ要件を満たしているか確認
- [ ] Shadow DOMのブラウザ互換性が対象ブラウザで問題ないか確認
- [ ] 初回ロード除外ロジック（previousTitle.current === undefined）が正しく動作しているか確認
