---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：42-エラー状態リクエスト通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15**：Pages Routerでの未対応に関する主張は推測に基づく（Pages Router側のhot-reloaderにハンドラが存在しないことから推測）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` - HMRメッセージ型定義（行38, 166-169）
- E-02: `packages/next/src/server/mcp/tools/get-errors.ts` - MCPツール登録、エラー取得処理（全141行）
- E-03: `packages/next/src/server/mcp/tools/utils/browser-communication.ts` - ブラウザ通信基盤（全97行）
- E-04: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` - ブラウザ側ハンドラ（行488-497）
- E-05: `packages/next/src/next-devtools/dev-overlay/shared.ts` - OverlayState型定義（行44-73）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義（行43）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | REQUEST_CURRENT_ERROR_STATEはJSON HMRメッセージ | E-01（行38） | ○ |
| C-02 | メッセージにtypeとrequestIdが含まれる | E-01（行166-169） | ○ |
| C-03 | MCPクライアントのget_errorsツールがトリガー | E-02（行36-38） | ○ |
| C-04 | テレメトリトラッキングが行われる | E-02（行45） | ○ |
| C-05 | 接続数0でエラーメッセージ返却 | E-02（行48-61） | ○ |
| C-06 | requestIdはnanoidで生成 | E-03（行41） | ○ |
| C-07 | タイムアウトは5000ms | E-03（行13） | ○ |
| C-08 | タイムアウト時に部分応答を返す | E-03（行47-48） | ○ |
| C-09 | ブラウザ側でgetSerializedOverlayStateを呼び出す | E-04（行489） | ○ |
| C-10 | MCP_ERROR_STATE_RESPONSEで応答を返す | E-04（行491） | ○ |
| C-11 | 応答にwindow.location.hrefが含まれる | E-04（行494） | ○ |
| C-12 | ルートごとのエラー状態をMapで管理 | E-02（行72-77） | ○ |
| C-13 | NextInstanceErrorStateも併せて返却 | E-02（行82-83, 99-101） | ○ |
| C-14 | formatErrorsでフォーマット処理 | E-02（行98-101） | ○ |
| C-15 | Pages Routerでは未対応 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- C-15について：Pages Router側のhot-reloaderコード（`hot-reloader-pages.ts`）にREQUEST_CURRENT_ERROR_STATEのハンドラが存在しないことから推測しているが、明示的に「未対応」と記載されたドキュメントやコメントは確認できていない
  - 候補：Pages Router hot-reloaderの全体コード確認 / 公式ドキュメント / チームへの確認

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - コアとなるリクエスト-レスポンスフローは全てソースコードで検証済み
- 1: 中リスク - Pages Router対応状況の確認が必要（C-15）

## 6) レビュアーチェックリスト（最小）

- [ ] MCPツール登録のシグネチャが正しいか確認
- [ ] タイムアウト処理（5秒）の挙動が正しいか確認
- [ ] ブラウザ側のハンドラが正しくOverlayStateを返すか確認
- [ ] Pages RouterでのREQUEST_CURRENT_ERROR_STATEの対応状況を確認
- [ ] formatErrorsの処理内容を確認
