---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：43-ページメタデータリクエスト通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **C-16**：SegmentTrieData型の詳細構造については型定義ファイルを直接確認していないため根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` - HMRメッセージ型定義（行39, 171-174）
- E-02: `packages/next/src/server/mcp/tools/get-page-metadata.ts` - MCPツール登録、メタデータ取得処理（全239行）
- E-03: `packages/next/src/server/mcp/tools/utils/browser-communication.ts` - ブラウザ通信基盤（全97行）
- E-04: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` - ブラウザ側ハンドラ（行499-508）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義（行44）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | REQUEST_PAGE_METADATAはJSON HMRメッセージ | E-01（行39） | ○ |
| C-02 | メッセージにtypeとrequestIdが含まれる | E-01（行171-174） | ○ |
| C-03 | MCPクライアントのget_page_metadataツールがトリガー | E-02（行24-25） | ○ |
| C-04 | テレメトリトラッキングが行われる | E-02（行33） | ○ |
| C-05 | 接続数0でエラーメッセージ返却 | E-02（行36-49） | ○ |
| C-06 | requestIdはnanoidで生成 | E-03（行41） | ○ |
| C-07 | タイムアウトは5000ms | E-03（行13） | ○ |
| C-08 | ブラウザ側でgetSegmentTrieDataを呼び出す | E-04（行500） | ○ |
| C-09 | MCP_PAGE_METADATA_RESPONSEで応答を返す | E-04（行502） | ○ |
| C-10 | convertSegmentTrieToPageMetadataでツリーを変換 | E-02（行132-160） | ○ |
| C-11 | ツリーの再帰的トラバースでセグメント収集 | E-02（行137-153） | ○ |
| C-12 | セグメントをタイプ順にソート | E-02（行194-206） | ○ |
| C-13 | 表示パスの加工処理（@boundary除去等） | E-02（行215-218） | ○ |
| C-14 | routerTypeでApp/Pages Router判別 | E-02（行158） | ○ |
| C-15 | formatPageMetadataでセッション単位に整形 | E-02（行179-239） | ○ |
| C-16 | SegmentTrieDataはsegmentTrieとrouterTypeを含む | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- C-16について：`SegmentTrieData`型は`packages/next/src/shared/lib/mcp-page-metadata-types.ts`からインポートされているが、このファイルの内容を直接確認していない。コード内の使用箇所（`data.segmentTrie`、`data.routerType`）から構造を推測している
  - 候補：`mcp-page-metadata-types.ts`の直接確認 / `segment-explorer-trie.ts`の型定義確認

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - コアとなるリクエスト-レスポンスフローは全てソースコードで検証済み
- 1: 中リスク - SegmentTrieData型の詳細構造の確認が必要（C-16）

## 6) レビュアーチェックリスト（最小）

- [ ] MCPツール登録のシグネチャが正しいか確認
- [ ] SegmentTrieData型の実際の構造を確認
- [ ] セグメントソートロジック（layout → boundary → page → その他）が正しいか確認
- [ ] パス加工ロジック（@boundary除去、__next_builtin__除去、app/付加）が正しいか確認
- [ ] 複数ブラウザセッション時の応答集約が正しいか確認
