---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-DevIndicator状態通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/dev-indicator-server-state.ts` - サーバー側状態定義（全5行）
- E-02: `packages/next/src/next-devtools/server/dev-indicator-middleware.ts` - 非表示操作ミドルウェア（全41行）
- E-03: `packages/next/src/server/dev/hot-reloader-types.ts` - HMRメッセージ型定義（行36, 75-85）
- E-04: `packages/next/src/next-devtools/dev-overlay/shared.ts` - OverlayState、リデューサー（行87, 260-261, 435-441）
- E-05: `packages/next/src/next-devtools/dev-overlay.browser.tsx` - ディスパッチャー（行169-172）
- E-06: `packages/next/src/client/dev/hot-reloader/app/hot-reloader-app.tsx` - App Router側ハンドラ（行313-314）
- E-07: `packages/next/src/client/dev/hot-reloader/pages/hot-reloader-pages.ts` - Pages Router側ハンドラ（行304-305）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義（行45）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DevIndicatorServerStateはdisabledUntilフィールドのみ | E-01（行3-5） | ○ |
| C-02 | disabledUntilの初期値は0 | E-01（行4） | ○ |
| C-03 | SYNCメッセージにdevIndicatorフィールドが含まれる | E-03（行83） | ○ |
| C-04 | DEV_INDICATORメッセージタイプが定義されている | E-03（行36） | ○ |
| C-05 | ミドルウェアが/__nextjs_disable_dev_indicatorパスで動作 | E-02（行6） | ○ |
| C-06 | POSTメソッドのみ許可 | E-02（行26） | ○ |
| C-07 | COOLDOWN_TIME_MSのデフォルトは24時間 | E-02（行10-11） | ○ |
| C-08 | 環境変数__NEXT_DEV_INDICATOR_COOLDOWN_MSでカスタマイズ可能 | E-02（行8-9） | ○ |
| C-09 | 204 No Contentで応答 | E-02（行32） | ○ |
| C-10 | エラー時にLog.errorとInternalServerError | E-02（行34-38） | ○ |
| C-11 | App RouterでdevIndicatorメッセージを処理 | E-06（行313-314） | ○ |
| C-12 | Pages RouterでdevIndicatorメッセージを処理 | E-07（行304-305） | ○ |
| C-13 | dispatcher.onDevIndicatorを呼び出す | E-05（行169-172） | ○ |
| C-14 | ACTION_DEV_INDICATORをディスパッチ | E-05（行171） | ○ |
| C-15 | リデューサーでshowIndicator=trueを設定 | E-04（行438） | ○ |
| C-16 | shouldDisableDevIndicatorは__NEXT_DEV_INDICATOR環境変数で決定 | E-04（行260-261） | ○ |
| C-17 | disableDevIndicator = shouldDisableDevIndicator OR disabledUntil | E-04（行439-440） | ○ |
| C-18 | INITIAL_OVERLAY_STATEでshowIndicatorの初期値はfalse | E-04（行282） | ○ |

## 4) 不足情報（Unknown / Missing）

特になし。DevIndicator状態通知に関するすべての主張がソースコードから直接検証可能。

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張がソースコードから直接検証可能であり、サーバー側・ブラウザ側の両方の処理が確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] devIndicatorServerStateの初期値（disabledUntil: 0）が正しいか確認
- [ ] ミドルウェアのCOOLDOWN_TIME_MS計算が正しいか確認
- [ ] SYNCメッセージへのdevIndicatorフィールド含有を確認
- [ ] リデューサーのshowIndicator/disableDevIndicatorの制御ロジックが正しいか確認
- [ ] App RouterとPages Routerの両方でハンドラが存在するか確認
- [ ] 環境変数__NEXT_DEV_INDICATOR_COOLDOWN_MSのパース処理が正しいか確認
