---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Webpack設定存在・Turbopack未設定エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/turbopack-warning.ts` - validateTurboNextConfig関数（行42-191）
- E-02: `packages/next/src/lib/turbopack-warning.ts` - 行147-167のエラー判定ブロック
- E-03: `packages/next/src/server/lib/start-server.ts` - 行478-483での呼び出し

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TURBOPACK === 'auto'の場合にのみ発動する | E-02（行147） | ○ |
| C-02 | hasWebpackConfigはrawNextConfig.webpackで判定 | E-01（行76） | ○ |
| C-03 | hasTurboConfigはrawNextConfig.turbopackで判定 | E-01（行77） | ○ |
| C-04 | experimental.turboで始まるキーもTurbopack設定として認識される | E-01（行117-119） | ○ |
| C-05 | Log.errorでエラーメッセージを出力する | E-02（行149-163） | ○ |
| C-06 | process.exit(1)でプロセスを終了する | E-02（行166） | ○ |
| C-07 | configFileNameで設定ファイル名を取得する | E-02（行148） | ○ |
| C-08 | 開発サーバー起動時に呼び出される | E-03（行478-483） | ○ |
| C-09 | No.4の警告とは異なりプロセスを終了する | E-02（行166 vs 行169-191にprocess.exitなし） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードで確認可能であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] `process.env.TURBOPACK === 'auto'`の設定タイミングが正しいか確認
- [ ] `process.exit(1)`が適切な位置で呼ばれるか確認
