---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 7
  claims_with_evidence: 7
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-nextモジュール直接インポート警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：7 / 7、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/import-next-warning.ts` - ファイル全体（行1-5）
- E-02: `packages/next/src/build/output/log.ts` - warn関数（行57-59）
- E-03: `packages/next/src/build/output/log.ts` - prefixedLog関数（行20-43）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モジュールのトップレベルでLog.warnが実行される | E-01（行3-5） | ○ |
| C-02 | module.parent?.filenameでインポート元を取得する | E-01（行4） | ○ |
| C-03 | ドキュメントURLが含まれる | E-01（行4） | ○ |
| C-04 | Log.warnは内部的にconsole.warnを使用する | E-02, E-03（行25-28） | ○ |
| C-05 | 5行のみのシンプルな実装である | E-01 | ○ |
| C-06 | 無条件に出力される（抑止条件なし） | E-01（条件分岐なし） | ○ |
| C-07 | Node.jsモジュールキャッシュにより同一プロセスで1回のみ | E-01（Node.jsのモジュールキャッシュ仕様） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードで確認可能であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] `import-next-warning.ts`の内容が設計書と一致するか確認
- [ ] `module.parent`の非推奨に関する将来的な対応が必要か確認
