---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Partytown依存パッケージ不足エラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/verify-partytown-setup.ts` - verifyPartytownSetup関数（行64-99）
- E-02: `packages/next/src/lib/verify-partytown-setup.ts` - missingDependencyError関数（行12-41）
- E-03: `packages/next/src/lib/verify-partytown-setup.ts` - hasNecessaryDependencies呼び出し（行69-75）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | hasNecessaryDependenciesで@builder.io/partytownの存在をチェック | E-03（行69-75） | ○ |
| C-02 | missing.lengthが0より大きい場合にmissingDependencyErrorを呼び出す | E-01（行77-78） | ○ |
| C-03 | getPkgManagerでパッケージマネージャーを検出する | E-02（行13） | ○ |
| C-04 | yarn/pnpm/npmに応じたインストールコマンドを生成する | E-02（行24-32） | ○ |
| C-05 | FatalErrorをthrowしてプロセスを停止する | E-02（行15） | ○ |
| C-06 | catchブロックでFatalError判定しconsole.errorで出力 | E-01（行90-96） | ○ |
| C-07 | FatalError後に再スローする | E-01（行95） | ○ |
| C-08 | nextScriptWorkers無効化の案内が含まれる | E-02（行34-38） | ○ |
| C-09 | 赤色太字でエラーメッセージが装飾される | E-02（行16-19） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードで確認可能であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] `hasNecessaryDependencies`のチェック対象パッケージ名が正しいか確認
- [ ] パッケージマネージャー別のインストールコマンドが正しいか確認
