---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-Partytownライブラリコピー失敗警告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/verify-partytown-setup.ts` - verifyPartytownSetup関数（行64-99）
- E-02: `packages/next/src/lib/verify-partytown-setup.ts` - copyPartytownStaticFiles関数（行43-62）
- E-03: `packages/next/src/lib/verify-partytown-setup.ts` - catchブロック（行82-88）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | copyPartytownStaticFilesの失敗時にcatchブロックでLog.warnが呼ばれる | E-03（行82-88） | ○ |
| C-02 | コピー先は{staticDir}/~partytownディレクトリ | E-02（行47） | ○ |
| C-03 | 既存ディレクトリを再帰的に削除してから再作成する | E-02（行53-55） | ○ |
| C-04 | @builder.io/partytownのutilsモジュールからcopyLibFilesを使用 | E-02（行57-59） | ○ |
| C-05 | プロセスは停止しない（警告のみ） | E-03（throwやprocess.exitなし） | ○ |
| C-06 | パッケージ名が太字cyanカラーで強調表示される | E-03（行84-86） | ○ |
| C-07 | パッケージ未インストールの場合はNo.7のエラーが先に発動する | E-01（行77-78） | ○ |
| C-08 | fileExistsでディレクトリの存在をチェックする | E-02（行48-51） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードで確認可能であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] コピー先ディレクトリのパスが正しいか確認
- [ ] エラー時の警告メッセージが設計書と一致するか確認
