---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-ページ追加通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/hot-reloader-types.ts` - HMR_MESSAGE_SENT_TO_BROWSER.ADDED_PAGE（行20）
- E-02: `packages/next/src/server/dev/hot-reloader-types.ts` - AddedPageMessage（行95-98）
- E-03: `packages/next/src/server/dev/hot-reloader-turbopack.ts` - 行718-742のルート変更検出
- E-04: `packages/next/src/server/dev/hot-reloader-webpack.ts` - 行1584-1611のchunkNames差分計算
- E-05: `packages/next/src/server/dev/hot-reloader-types.ts` - sendメソッド定義（行233）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ADDED_PAGEはenum値'addedPage'として定義されている | E-01（行20） | ○ |
| C-02 | dataフィールドはタプル型[page: string or null] | E-02（行97） | ○ |
| C-03 | TurbopackではaddedRoutesをループして各ルートに対して送信 | E-03（行730-735） | ○ |
| C-04 | Webpackではdiff(chunkNames, prevChunkNames)で追加ページを検出 | E-04（行1587） | ○ |
| C-05 | WebpackではgetRouteFromEntrypointでルートパスに変換 | E-04（行1592） | ○ |
| C-06 | 初回コンパイル時はprevChunkNamesが未設定で差分計算スキップ | E-04（行1584） | ○ |
| C-07 | ページ追加時にDEV_PAGES_MANIFEST_UPDATEも送信される | E-03（行718-727） | ○ |
| C-08 | hotReloader.sendでWebSocket経由の全クライアントブロードキャスト | E-05（行233） | ○ |
| C-09 | JSON形式のメッセージとして送信される | E-01（行19のコメント"JSON messages"） | ○ |
| C-10 | Webpackの場合prevChunkNamesが更新される | E-04（行1611） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張がソースコードで確認可能であり、リスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] Turbopack版とWebpack版の両方でADDED_PAGEメッセージが正しく送信されるか確認
- [ ] メッセージのdata構造が型定義と一致するか確認
