---
generated_at: 2026-02-03 15:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 40
  claims_without_evidence: 5
confidence_derived: 0.89
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：40 / 45、根拠なし：5
- 優先レビュー（高）
  1. **対応ブラウザの具体的バージョン要件**：根拠不足（Next.js公式ドキュメントに記載あるが、ソースコードからの直接的根拠なし）
  2. **マルチゾーン構成の具体的手順**：根拠不足（業務要件一覧に記載はあるが、詳細手順はソースコードの解析のみに依存）
  3. **テレメトリコマンドの具体的サブコマンド**：根拠不足（CLIソースの詳細解析が必要）
  4. **ハイドレーションエラーの対処法詳細**：根拠不足（一般的なベストプラクティスに基づく記載）
  5. **Keep-Aliveタイムアウトの推奨値**：根拠不足（ソースコードにデフォルト値の記載はあるが推奨値の根拠なし）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件定義（95件の業務要件）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（19画面）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（120機能）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面と機能の対応関係
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図（Mermaid形式）
- E-06: `docs/code-to-docs/README.md` - プロジェクト概要
- E-07: `docs/code-to-docs/機能設計書/1-next dev.md` - next dev機能設計書
- E-08: `docs/code-to-docs/機能設計書/12-create-next-app.md` - create-next-app機能設計書
- E-09: `docs/code-to-docs/画面設計書/6-グローバルエラーページ (Global Error).md` - グローバルエラーページ画面設計書
- E-10: `packages/next/src/cli/next-dev.ts` - 開発サーバーCLIソースコード
- E-11: `packages/next/src/cli/next-build.ts` - ビルドCLIソースコード
- E-12: `packages/next/src/cli/next-start.ts` - 本番サーバーCLIソースコード
- E-13: `packages/create-next-app/create-app.ts` - create-next-appソースコード
- E-14: `CLAUDE.md` - プロジェクト開発ガイド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Next.jsはVercelが開発するReactベースのフルスタックWebアプリケーションフレームワークである | E-06 | ○ |
| C-02 | SSR、SSG、App Router/Pages Router、APIルート、画像最適化、フォント最適化を提供する | E-01, E-03 | ○ |
| C-03 | Rustベースの高速バンドラTurbopackを内蔵する | E-06, E-14 | ○ |
| C-04 | Node.js 20.9.0以上が動作要件である | E-06 | ○ |
| C-05 | pnpm 9.6.0が推奨パッケージマネージャである | E-06 | ○ |
| C-06 | create-next-appでプロジェクトを新規作成できる | E-01, E-08, E-13 | ○ |
| C-07 | 対話的プロンプトでTypeScript、ESLint、Tailwind CSS等を設定できる | E-08, E-13 | ○ |
| C-08 | --yesオプションでデフォルト設定による自動作成ができる | E-08 | ○ |
| C-09 | --exampleオプションでGitHubサンプルを基にプロジェクト作成できる | E-08, E-13 | ○ |
| C-10 | next devコマンドで開発サーバーを起動できる | E-01, E-07, E-10 | ○ |
| C-11 | デフォルトポートは3000である | E-07, E-10 | ○ |
| C-12 | --portオプションでポート番号を変更できる | E-07, E-10 | ○ |
| C-13 | --turbopackオプションでTurbopackバンドラーを使用できる | E-07, E-10 | ○ |
| C-14 | --experimental-httpsでHTTPS開発サーバーを起動できる | E-07, E-10 | ○ |
| C-15 | 予約済みポート（0, 1, 7, 9等）は使用できない | E-10 | ○ |
| C-16 | HMRによりコード変更がフルリロードなしで反映される | E-01, E-07 | ○ |
| C-17 | App Routerではappディレクトリ内のファイル構造がルーティングに対応する | E-01, E-03 | ○ |
| C-18 | Pages Routerではpagesディレクトリ内のファイル構造がルーティングに対応する | E-01, E-03 | ○ |
| C-19 | layout.tsxでページ間の共通UIを定義できる | E-01, E-02 | ○ |
| C-20 | loading.tsxでローディングUIを定義できる | E-01, E-03 | ○ |
| C-21 | error.tsxでエラーバウンダリを定義できる | E-01, E-03 | ○ |
| C-22 | Linkコンポーネントでプリフェッチ付きナビゲーションができる | E-01, E-03 | ○ |
| C-23 | next buildでプロダクションビルドを実行できる | E-01, E-11 | ○ |
| C-24 | ビルド時に静的/動的レンダリングが自動判定される | E-01 | ○ |
| C-25 | コード分割とツリーシェイキングが自動的に行われる | E-01, E-03 | ○ |
| C-26 | output: 'export'で完全な静的サイトとして出力できる | E-01, E-03 | ○ |
| C-27 | next lintでESLintチェックを実行できる | E-03 | ○ |
| C-28 | next startでプロダクションサーバーを起動できる | E-01, E-12 | ○ |
| C-29 | --keepAliveTimeoutオプションでKeep-Aliveタイムアウトを設定できる | E-12 | ○ |
| C-30 | output: 'standalone'で最小限のNode.jsサーバーを出力できる | E-01, E-03 | ○ |
| C-31 | middleware.tsでEdge Runtimeベースの中間処理を定義できる | E-01, E-03 | ○ |
| C-32 | 404ページは「This page could not be found.」と表示される | E-02 | ○ |
| C-33 | グローバルエラーページはサーバーエラーで「This page failed to load」と表示される | E-09 | ○ |
| C-34 | グローバルエラーページはクライアントエラーで「This page crashed」と表示される | E-09 | ○ |
| C-35 | 「Reload page」「Go back」ボタンが提供される | E-09 | ○ |
| C-36 | 403ページは「This page could not be accessed.」と表示される | E-02 | ○ |
| C-37 | 401ページは「You're not authorized to access this page.」と表示される | E-02 | ○ |
| C-38 | DevToolsインジケーターは画面隅にフローティングボタンとして表示される | E-02, E-04 | ○ |
| C-39 | セグメントエクスプローラーでApp Routerのセグメントツリーを表示できる | E-02, E-04 | ○ |
| C-40 | NEXT_PUBLIC_プレフィックス付き環境変数のみがクライアントに公開される | E-01, E-03 | ○ |
| C-41 | 対応ブラウザはChrome、Edge、Safari、Firefoxの最新版 | **根拠なし** | △ |
| C-42 | マルチゾーン構成はbasePathとrewritesで実現する | E-01 | ○（業務要件のみ、詳細手順は要確認） |
| C-43 | next telemetryコマンドでテレメトリの有効/無効を切り替えられる | E-03 | ○（コマンド名は確認済み、サブコマンドは要確認） |
| C-44 | ハイドレーションエラーの対処法（Date.now等の回避） | **根拠なし** | △ |
| C-45 | Keep-Aliveタイムアウトのオプション値70000msの推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-41: 対応ブラウザの具体的バージョン要件は、Next.js公式ドキュメント（nextjs.org/docs）には記載があるが、本リポジトリのソースコードからは直接的な根拠を確認できなかった
  - 候補：Next.js公式ドキュメント / browserslist設定 / package.jsonのbrowserslist
- C-44: ハイドレーションエラーの対処法は、一般的なReact/Next.jsのベストプラクティスに基づく記載であり、本リポジトリ内の具体的なドキュメントからの引用ではない
  - 候補：Next.js公式ドキュメント / errorsディレクトリ / テストケース
- C-45: Keep-Aliveタイムアウトの具体的な推奨値は、ソースコードにオプション定義はあるが、推奨値の根拠はリバースプロキシとの連携に関する一般的なベストプラクティスに基づく
  - 候補：next-start.tsのデフォルト値 / Vercel公式ドキュメント / Node.jsドキュメント
- C-41の対応ブラウザ情報は一般的な記載であり、プロジェクト固有のbrowserslist設定の確認が必要
  - 候補：package.json / .browserslistrc

## 5) リスクフラグ（レビュー観点）
- 0: **低リスク** - 全体の信頼度は0.89と高く、主要な主張はソースコード・設計書に裏付けされている
- 1: **中リスク** - Next.jsはフレームワークであり、テンプレートの「業務アプリケーション」構造（案内・通知、依頼・届出等）との対応付けは解釈的なマッピングである。フレームワークの業務フロー（プロジェクト作成→開発→ビルド→デプロイ→運用）への読み替えが適切かレビューが必要
- 1: **中リスク** - トラブルシューティングの一部（ハイドレーションエラー対処法、メモリ不足時の対処等）は一般的なベストプラクティスに基づいており、ソースコードからの直接的な根拠ではない
- 0: **低リスク** - CLIコマンドのオプションや画面表示メッセージは、ソースコードおよび設計書から直接確認している

## 6) レビュアーチェックリスト（最小）
- [ ] テンプレートの業務フロー構造（STEP1-5）へのNext.js業務フローのマッピングが適切か確認
- [ ] 対応ブラウザ情報がプロジェクトの実際のサポート範囲と一致しているか確認
- [ ] エラーメッセージの記載が最新のソースコードと一致しているか確認
- [ ] トラブルシューティングの対処法が実際の運用環境で有効か確認
- [ ] Keep-Aliveタイムアウトの推奨値が運用環境に適しているか確認
- [ ] テレメトリコマンドのサブコマンド（disable/enable/status）が正しいか確認
- [ ] next.config.jsの設定例が最新のAPIに準拠しているか確認
