# Next.js 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順（初期セットアップ）](#2-ログインログアウト手順初期セットアップ)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】プロジェクト作成・初期設定（案内・通知機能に相当）](#4-step1プロジェクト作成初期設定案内通知機能に相当)
5. [【STEP2-3】開発サーバーでの開発作業（依頼・届出機能に相当）](#5-step2-3開発サーバーでの開発作業依頼届出機能に相当)
6. [【STEP3-4】ビルド・最適化（ファイル共有機能に相当）](#6-step3-4ビルド最適化ファイル共有機能に相当)
7. [【STEP4-5】本番デプロイ・サーバー起動（管理・処理完了に相当）](#7-step4-5本番デプロイサーバー起動管理処理完了に相当)

**【サポート機能】**
8. [エラーハンドリング機能](#8-エラーハンドリング機能)
9. [開発者ツール（DevTools）](#9-開発者ツールdevtools)
10. [設定・カスタマイズ機能](#10-設定カスタマイズ機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Next.jsとは

Next.jsは、Vercelが開発・メンテナンスするReactベースのフルスタックWebアプリケーションフレームワークです。サーバーサイドレンダリング（SSR）、静的サイト生成（SSG）、App Router / Pages Router、APIルート、画像最適化、フォント最適化など、本番レベルのWebアプリケーション構築に必要な機能を包括的に提供します。

Rustベースの高速バンドラTurbopackを内蔵し、開発・ビルドの高速化を実現しています。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **プロジェクト作成** | 新規Next.jsプロジェクトの作成、テンプレートベースのプロジェクト生成 |
| **開発** | 開発サーバーの起動、Hot Module Replacement（HMR）、エラー確認・デバッグ |
| **ビルド・最適化** | プロダクションビルドの実行、コード分割、画像最適化、フォント最適化 |
| **ルーティング設計** | App Router / Pages Routerによるページルーティング、APIルートの定義 |
| **本番運用** | プロダクションサーバーの起動、静的エクスポート、パフォーマンス計測 |
| **品質管理** | ESLintによるコード品質チェック、TypeScript型チェック、テスト実行 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
+-------------------------------------------------------------------+
|                        業務フロー                                  |
+-------------------------------------------------------------------+
|                                                                    |
|  【STEP 1】開発者がプロジェクトを新規作成・初期設定を行う           |
|      |                                                             |
|  【STEP 2】開発者が開発サーバーを起動し、コードを編集・確認する     |
|      |                                                             |
|  【STEP 3】開発者がビルドを実行し、最適化・品質チェックを行う       |
|      |                                                             |
|  【STEP 4】運用者が本番サーバーを起動し、アプリケーションを配信する |
|      |                                                             |
|  【STEP 5】エンドユーザーがアプリケーションを利用する               |
|                                                                    |
+-------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **開発者** | プロジェクト作成、コード開発、ビルド、テスト、デバッグ、設定管理 |
| **運用者** | 本番サーバーの起動・管理、デプロイ、パフォーマンス監視 |
| **エンドユーザー** | 完成したWebアプリケーションの利用（ページ閲覧、フォーム操作、ナビゲーション） |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| create-next-app | プロジェクトの新規作成・スキャフォールディング | STEP 1 |
| next dev | 開発サーバーの起動とHMRによる即時反映 | STEP 2 |
| App Router / Pages Router | ファイルシステムベースのルーティング | STEP 2-3 |
| next build | プロダクション用の最適化ビルド | STEP 3 |
| next start | プロダクションサーバーの起動 | STEP 4 |
| エラーハンドリング | 404/500/403/401エラーページの自動表示 | STEP 5 |
| 画像・フォント最適化 | next/image、next/fontによる自動最適化 | STEP 3-5 |
| DevTools | 開発時のエラーオーバーレイ、ルート情報表示 | STEP 2（開発時） |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 開発者 | Next.jsアプリケーションのコードを開発・テスト・デバッグする担当者。CLIコマンドを直接操作する |
| 運用者 | ビルド済みアプリケーションを本番環境にデプロイ・運用する担当者。サーバー起動や環境設定を行う |
| エンドユーザー | 完成したWebアプリケーションをブラウザで利用するユーザー。ページ閲覧やフォーム操作を行う |

### 1.6 対応ブラウザ

Next.jsが生成するアプリケーションの推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

開発ツール（DevTools、エラーオーバーレイ）は上記ブラウザで動作します。

### 1.7 動作要件

| 項目 | 要件 |
|------|------|
| Node.js | 20.9.0 以上 |
| パッケージマネージャ | npm / pnpm 9.6.0 / yarn / bun |
| Rust（オプション） | nightly-2026-01-04（Turbopack/SWCのネイティブビルドを行う場合） |

---

## 2. ログイン・ログアウト手順（初期セットアップ）

Next.jsはフレームワークであるため、従来のログイン・ログアウトの概念とは異なります。ここでは、開発環境の初期セットアップ手順を記載します。

### 2.1 開発環境のセットアップ

1. Node.jsがインストールされていることを確認します

```
node -v
```

バージョンが20.9.0以上であることを確認してください。

2. パッケージマネージャの準備

pnpmを使用する場合は `corepack enable` で有効化できます：

```
corepack enable
```

3. プロジェクトの依存関係をインストールします

```
pnpm install
```

### 2.2 開発サーバーへのアクセス

1. 開発サーバーを起動します

```
next dev
```

2. ブラウザで表示されたURLにアクセスします（デフォルト: `http://localhost:3000`）

3. 開発サーバーが正常に起動すると、ターミナルに「Ready in Xs」のメッセージが表示されます

### 2.3 開発サーバーの停止

1. ターミナルで `Ctrl + C` を押してサーバーを停止します
2. サーバーはSIGINT/SIGTERMシグナルを受信して安全にシャットダウンします

---

## 3. トップページ（TOP画面）

### 3.1 エンドユーザー向け画面

Next.jsアプリケーションのトップページは、開発者が定義するページコンポーネントによって構成されます。

- **App Router使用時**: `app/page.tsx`（または`app/page.jsx`）ファイルがルートURL（`/`）に対応します
- **Pages Router使用時**: `pages/index.tsx`（または`pages/index.jsx`）ファイルがルートURL（`/`）に対応します

ユーザーがブラウザでアプリケーションのルートURLにアクセスすると、上記のページコンポーネントがレンダリングされて表示されます。

### 3.2 開発者向けDevTools画面

開発モード（`next dev`）で起動した場合、ブラウザの画面隅にNext.jsのDevToolsインジケーター（Next.jsロゴのフローティングボタン）が表示されます。このインジケーターは以下の情報を提供します：

- **Issues数**: 現在のエラー数
- **ルート種別**: Static / Dynamic の表示
- **バンドラー情報**: 使用中のバンドラー（Turbopack等）

DevToolsインジケーターはドラッグで画面の四隅に移動でき、ユーザー設定パネルから非表示にすることも可能です。

---

## 4. 【STEP1】プロジェクト作成・初期設定（案内・通知機能に相当）

> **業務フローでの位置**: 開発者がNext.jsプロジェクトを新規作成し、初期設定を行うステップです。テンプレート選択やオプション設定により、プロジェクトの基盤を構築します。

### 4.1 新規プロジェクトを作成する（開発者向け）

**業務シーン**: 新しいWebアプリケーションの開発を開始する場合

**前提条件**: Node.js 20.9.0以上がインストールされていること

**操作手順**:

1. ターミナルを開きます
2. 以下のコマンドを実行します

```
npx create-next-app@latest my-app
```

3. 対話的なプロンプトが表示されます。以下の設定を選択してください：

| 設定項目 | 選択肢 | 推奨 |
|----------|--------|------|
| TypeScript使用 | Yes / No | Yes |
| ESLint使用 | Yes / No | Yes |
| Tailwind CSS使用 | Yes / No | プロジェクトに応じて |
| src/ディレクトリ使用 | Yes / No | プロジェクトに応じて |
| App Router使用 | Yes / No | Yes（新規プロジェクトの場合） |
| インポートエイリアス | カスタマイズ可能 | デフォルト（@/*） |

4. 設定完了後、依存関係が自動的にインストールされます
5. プロジェクトディレクトリに移動します

```
cd my-app
```

**注意点・Tips**:
- `--yes` オプションを付けるとデフォルト設定で自動作成されます
- `--example` オプションでGitHubのサンプルプロジェクトをベースにできます
- CI環境では対話的プロンプトはスキップされ、デフォルト値が使用されます

### 4.2 テンプレートベースのプロジェクト生成

**業務シーン**: 既存のサンプルプロジェクトをベースに開発を始めたい場合

**操作手順**:

1. 以下のコマンドでサンプルプロジェクトを指定して作成します

```
npx create-next-app@latest my-app --example with-tailwindcss
```

2. GitHubリポジトリのURLを直接指定することも可能です

```
npx create-next-app@latest my-app --example https://github.com/vercel/next.js/tree/canary/examples/with-tailwindcss
```

### 4.3 プロジェクト設定の確認と変更

プロジェクト作成後、`next.config.js`（または`next.config.ts`）ファイルで各種設定を管理します。

**主要な設定項目**:

| 設定項目 | 説明 | 設定例 |
|----------|------|--------|
| basePath | アプリケーションのベースパス | `basePath: '/docs'` |
| images | 画像最適化の設定 | `images: { domains: ['example.com'] }` |
| i18n | 国際化（多言語対応）設定 | `i18n: { locales: ['ja', 'en'] }` |
| rewrites | URLリライト設定 | カスタムルーティングルール |
| redirects | URLリダイレクト設定 | パス変更時の転送ルール |
| headers | カスタムHTTPヘッダー | セキュリティヘッダーの追加 |

---

## 5. 【STEP2-3】開発サーバーでの開発作業（依頼・届出機能に相当）

> **業務フローでの位置**: 開発者が開発サーバーを起動し、コードを編集・確認しながらアプリケーションを構築するステップです。

### 5.1 開発サーバーの起動

**業務シーン**: アプリケーションの開発・テスト・デバッグを行う場合

**前提条件**: プロジェクトの依存関係がインストール済みであること

**操作手順**:

1. プロジェクトのルートディレクトリでターミナルを開きます
2. 以下のコマンドを実行します

```
next dev
```

3. ターミナルに以下のような出力が表示されます

```
   - Local:        http://localhost:3000
   - Ready in Xs
```

4. ブラウザで `http://localhost:3000` にアクセスします

**オプション指定**:

| オプション | 説明 | 使用例 |
|-----------|------|--------|
| `--port` / `-p` | ポート番号を指定 | `next dev -p 4000` |
| `--hostname` / `-H` | ホスト名を指定 | `next dev -H 0.0.0.0` |
| `--turbopack` | Turbopackバンドラーを使用（高速） | `next dev --turbopack` |
| `--experimental-https` | HTTPS開発サーバーを起動 | `next dev --experimental-https` |

**注意点・Tips**:
- ポート3000が使用中の場合、自動的に別のポートが選択されます
- 予約済みポート（0, 1, 7, 9, 11, 13, 15, 17, 19, 20, 21等）は使用できません
- `--turbopack` オプションを使用するとビルドが高速化されます

### 5.2 ページの作成とルーティング

**App Routerの場合（推奨）**:

`app/` ディレクトリ内にファイルを配置することでルーティングが自動的に定義されます。

| ファイル | URL | 説明 |
|---------|-----|------|
| `app/page.tsx` | `/` | トップページ |
| `app/about/page.tsx` | `/about` | Aboutページ |
| `app/blog/[slug]/page.tsx` | `/blog/:slug` | ブログ記事（動的ルート） |
| `app/api/route.ts` | `/api` | APIエンドポイント |

**レイアウトファイル**:

`layout.tsx` ファイルでページ間の共通UIを定義します。

| ファイル | 説明 |
|---------|------|
| `app/layout.tsx` | ルートレイアウト（html/bodyタグを含む） |
| `app/blog/layout.tsx` | /blog配下のページに適用されるレイアウト |

**特殊ファイル**:

| ファイル | 説明 |
|---------|------|
| `loading.tsx` | ページ読み込み中のローディングUI（React Suspenseと統合） |
| `error.tsx` | エラー発生時のフォールバックUI（Error Boundary） |
| `not-found.tsx` | 404ページのカスタマイズ |

**Pages Routerの場合**:

`pages/` ディレクトリ内にファイルを配置します。

| ファイル | URL |
|---------|-----|
| `pages/index.tsx` | `/` |
| `pages/about.tsx` | `/about` |
| `pages/blog/[slug].tsx` | `/blog/:slug` |
| `pages/api/hello.ts` | `/api/hello` |

### 5.3 Hot Module Replacement（HMR）

開発サーバー起動中は、ソースコードを編集して保存すると、ブラウザがフルリロードすることなく変更が即座に反映されます。

**対応内容**:
- コンポーネントの変更
- スタイルの変更
- 設定ファイルの変更（一部は再起動が必要）

**注意点**:
- `next.config.js` の変更はサーバーの再起動が必要です
- 環境変数（`.env`ファイル）の変更もサーバーの再起動が必要です

### 5.4 データ取得

**App Routerでのデータ取得**:

Server Components内で直接 `fetch` を使用できます。キャッシュ制御・再検証が自動的に管理されます。

**Pages Routerでのデータ取得**:

| 関数 | タイミング | 用途 |
|------|-----------|------|
| `getServerSideProps` | リクエスト時 | SSR用データ取得 |
| `getStaticProps` | ビルド時 | SSG用データ取得 |
| `getStaticPaths` | ビルド時 | 動的ルートの事前生成パス定義 |

### 5.5 ナビゲーション

ページ間の遷移には以下の方法を使用します：

| 方法 | 説明 | 使用場面 |
|------|------|---------|
| `<Link>` コンポーネント | クライアントサイドナビゲーション | テンプレート内のリンク |
| `useRouter` フック | プログラマティックナビゲーション | ボタンクリック等のイベント |
| `redirect` 関数 | サーバーサイドリダイレクト | Server Components / Server Actions |
| `<Form>` コンポーネント | フォーム送信とナビゲーション統合 | 検索フォーム等 |

`<Link>` コンポーネントはプリフェッチ機能を備えており、リンク先のページデータを事前に取得してナビゲーションを高速化します。

---

## 6. 【STEP3-4】ビルド・最適化（ファイル共有機能に相当）

> **業務フローでの位置**: 開発完了後、アプリケーションをプロダクション用にビルドし、最適化を行うステップです。

### 6.1 プロダクションビルドの実行

**業務シーン**: 開発が完了し、本番環境にデプロイするための最適化されたビルドを作成する場合

**操作手順**:

1. プロジェクトのルートディレクトリで以下のコマンドを実行します

```
next build
```

2. ビルドが完了すると、以下の情報が表示されます：
   - 各ページのレンダリング種別（Static / Dynamic）
   - バンドルサイズ
   - ビルド時間

3. ビルド成果物は `.next/` ディレクトリに生成されます

**主要なビルドオプション**:

| オプション | 説明 |
|-----------|------|
| `--turbopack` | Turbopackバンドラーを使用して高速ビルド |
| `--profile` | プロファイリング情報を含むビルド |
| `--debug` | デバッグ情報を含むビルド |

### 6.2 静的/動的レンダリングの自動判定

ビルド時に各ページが自動的に解析され、以下のように判定されます：

| マーク | 種別 | 説明 |
|--------|------|------|
| ○ | Static | ビルド時にHTMLが事前生成される |
| lambda | Dynamic | リクエスト時にサーバーでレンダリングされる |
| ISR | Incremental Static Regeneration | 静的生成後、一定期間で再生成される |

### 6.3 コード分割と最適化

ビルド時に自動的に行われる最適化：

- **コード分割**: ページ・ルート単位で自動的にJavaScriptが分割され、必要なコードのみが配信されます
- **ツリーシェイキング**: 未使用のコードが自動的に除去されます
- **画像最適化**: `next/image` コンポーネントを使用した画像が自動的にリサイズ・フォーマット変換されます
- **フォント最適化**: `next/font` を使用したフォントが自動的にセルフホスティング・最適化されます

### 6.4 静的エクスポート

完全な静的サイトとして出力する場合：

1. `next.config.js` に以下の設定を追加します

```js
module.exports = {
  output: 'export'
}
```

2. `next build` を実行します
3. `out/` ディレクトリに静的ファイルが生成されます
4. 任意のホスティングサービスにデプロイできます

### 6.5 コード品質チェック

**ESLintによるチェック**:

```
next lint
```

Next.js固有のESLintルール（eslint-plugin-next）により、ベストプラクティスに基づくコード品質チェックが実行されます。

**TypeScript型チェック**:

ビルド時に自動的にTypeScript型チェックが実行されます。個別に実行する場合は `pnpm types` コマンドを使用します。

---

## 7. 【STEP4-5】本番デプロイ・サーバー起動（管理・処理完了に相当）

> **業務フローでの位置**: 運用者がビルド済みアプリケーションを本番環境にデプロイし、エンドユーザーにサービスを提供するステップです。

### 7.1 プロダクションサーバーの起動

**業務シーン**: ビルド済みアプリケーションを本番環境で公開する場合

**前提条件**: `next build` が正常に完了していること

**操作手順**:

1. 以下のコマンドを実行します

```
next start
```

2. サーバーが起動し、以下のような出力が表示されます

```
   - Local:        http://localhost:3000
   - Ready in Xs
```

3. ブラウザからアクセスして動作を確認します

**主要なオプション**:

| オプション | 説明 | 使用例 |
|-----------|------|--------|
| `--port` / `-p` | ポート番号を指定 | `next start -p 8080` |
| `--hostname` / `-H` | ホスト名を指定 | `next start -H 0.0.0.0` |
| `--keepAliveTimeout` | HTTP Keep-Aliveタイムアウト（ミリ秒） | `next start --keepAliveTimeout 70000` |

### 7.2 スタンドアロン出力（コンテナデプロイ向け）

Dockerコンテナ等へのデプロイに最適化された出力を行う場合：

1. `next.config.js` に以下の設定を追加します

```js
module.exports = {
  output: 'standalone'
}
```

2. `next build` を実行します
3. `.next/standalone/` ディレクトリに最小限のNode.jsサーバーが生成されます
4. `node .next/standalone/server.js` で起動できます

**注意点**:
- `public/` ディレクトリと `.next/static/` ディレクトリは手動でコピーが必要です
- 環境変数は実行時に設定します

### 7.3 マルチゾーン構成

複数のNext.jsアプリケーションを単一ドメインで統合配信する場合：

1. 各アプリケーションに `basePath` を設定します
2. リバースプロキシまたは `rewrites` 設定で統合します

### 7.4 ミドルウェアの設定

本番環境でのリクエスト前処理（認証チェック、リダイレクト、ヘッダー操作等）：

プロジェクトルートに `middleware.ts` ファイルを配置することで、Edge Runtimeベースの中間処理が実行されます。

**主な用途**:
- 認証状態のチェックとリダイレクト
- URLのリライト
- レスポンスヘッダーの追加
- Cookie操作

---

## 8. エラーハンドリング機能

### 8.1 エラーページの種類

Next.jsは以下のエラーページを自動的に提供します：

| エラーページ | 状況 | 表示メッセージ |
|------------|------|--------------|
| 404ページ（Not Found） | ページが見つからない場合 | "404: This page could not be found." |
| グローバルエラーページ（Global Error） | キャッチされないエラー発生時 | サーバーエラー: "This page failed to load" / クライアントエラー: "This page crashed" |
| 500エラーページ（App Error） | サーバーエラー発生時 | "This page failed to load" |
| 403ページ（Forbidden） | アクセス権限がない場合 | "403: This page could not be accessed." |
| 401ページ（Unauthorized） | 未認証の場合 | "401: You're not authorized to access this page." |

### 8.2 エラー発生時のエンドユーザー操作

**グローバルエラーページが表示された場合**:

1. 画面に表示されるエラーメッセージを確認します
2. 「Reload page」ボタンをクリックしてページをリロードします
3. クライアントエラーの場合は「Go back」ボタンで前のページに戻ることもできます
4. エラーが繰り返し発生する場合は、画面下部のエラーリファレンスコードを控えて管理者に連絡してください

**404ページが表示された場合**:

1. URLが正しいか確認してください
2. ブラウザの「戻る」ボタンで前のページに戻ります
3. トップページに移動して目的のページを探します

### 8.3 エラーページのカスタマイズ（開発者向け）

各エラーページは以下のファイルでカスタマイズできます：

| エラー種別 | App Router | Pages Router |
|-----------|-----------|-------------|
| 404 | `app/not-found.tsx` | `pages/404.tsx` |
| 500 | `app/error.tsx` | `pages/500.tsx` |
| グローバルエラー | `app/global-error.tsx` | `pages/_error.tsx` |
| 403 | `forbidden()` 関数で制御 | - |
| 401 | `unauthorized()` 関数で制御 | - |

---

## 9. 開発者ツール（DevTools）

### 9.1 開発オーバーレイ

開発モード（`next dev`）で起動した場合、以下の開発者ツールが利用できます。

**DevToolsインジケーター**:
- 画面隅にNext.jsロゴのフローティングボタンが表示されます
- クリックするとDevToolsメニューが開きます
- ドラッグで画面の四隅に移動できます

**DevToolsメニュー（Panel Selector）の機能**:

| メニュー項目 | 説明 |
|-------------|------|
| Issues | 現在のエラー数とエラーオーバーレイの表示 |
| Route | 現在のルートがStatic/Dynamicかを表示 |
| Route Info | App Routerのセグメントツリーをビジュアル表示 |
| Preferences | テーマ、表示位置、スケール等の設定 |

### 9.2 ビルドエラーの確認

コンパイルエラーが発生した場合、ブラウザ上に自動的にオーバーレイが表示されます。

**表示内容**:
- エラーメッセージ
- エラー発生ファイルのパスと行番号
- ターミナル風のエラー出力

**対処方法**:
1. エラーメッセージを確認します
2. 表示されたファイルパスと行番号を参照して該当箇所を修正します
3. ファイルを保存すると自動的にリコンパイルされます
4. エラーが解消されるとオーバーレイが自動的に閉じます

### 9.3 ランタイムエラーの確認

実行時エラーが発生した場合もオーバーレイが表示されます。

**表示内容**:
- エラー種別（ハイドレーションエラー、ブロッキングルートエラー、一般ランタイムエラー）
- コードフレーム
- コールスタック

**注意点**:
- ランタイムエラーオーバーレイは開発モードのみで表示されます
- 本番環境では `error.tsx` で定義したフォールバックUIが表示されます

### 9.4 セグメントエクスプローラー

App Router使用時に利用できる機能で、現在のページのセグメントツリーをビジュアルに表示します。

**操作手順**:
1. DevToolsインジケーターをクリックします
2. メニューから「Route Info」を選択します
3. セグメントツリーが表示されます（layout, page, error, loading等のファイル構成）
4. パネルはリサイズ・ドラッグが可能です

### 9.5 ユーザー設定パネル

**操作手順**:
1. DevToolsインジケーターをクリックします
2. メニューから「Preferences」を選択します
3. 以下の設定を変更できます：
   - テーマ（ライト/ダーク）
   - 表示位置
   - スケール
   - 非表示ショートカット

---

## 10. 設定・カスタマイズ機能

### 10.1 next.config.js / next.config.ts

プロジェクト全体の設定を管理するファイルです。プロジェクトルートに配置します。

**主要な設定カテゴリ**:

| カテゴリ | 設定例 | 説明 |
|---------|--------|------|
| ルーティング | `basePath`, `rewrites`, `redirects` | URL構造の制御 |
| 画像最適化 | `images` | 外部画像ドメイン、サイズ設定 |
| 国際化 | `i18n` | 多言語対応設定 |
| ビルド | `output`, `distDir` | 出力形式の制御 |
| セキュリティ | `headers` | カスタムHTTPヘッダー |

### 10.2 環境変数の管理

`.env` ファイルにより環境変数を管理します。

| ファイル | 用途 |
|---------|------|
| `.env` | 全環境共通の環境変数 |
| `.env.local` | ローカル環境固有の環境変数（Git管理外） |
| `.env.development` | 開発環境用の環境変数 |
| `.env.production` | 本番環境用の環境変数 |

**重要**: `NEXT_PUBLIC_` プレフィックスを付けた環境変数のみがクライアントサイド（ブラウザ）に公開されます。機密情報（APIキー等）にはこのプレフィックスを使用しないでください。

### 10.3 TypeScript設定

Next.jsは `tsconfig.json` を自動生成・管理します。TypeScriptの型チェックはビルド時に自動的に実行されます。

型定義の自動生成は以下のコマンドで実行できます：

```
next typegen
```

### 10.4 テレメトリの管理

Next.jsは匿名の利用統計を収集します。テレメトリの有効/無効を切り替えるには：

```
next telemetry disable    # テレメトリを無効化
next telemetry enable     # テレメトリを有効化
next telemetry status     # 現在のステータスを確認
```

環境変数 `NEXT_TELEMETRY_DISABLED=1` でも無効化できます。

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
================================================================
【STEP 1】開発者がプロジェクトを新規作成・初期設定     -> 4章参照
    |
【STEP 2】開発者が開発サーバーを起動し、コードを編集   -> 5章参照
    |
【STEP 3】開発者がビルドを実行し、最適化・品質チェック -> 6章参照
    |
【STEP 4】運用者が本番サーバーを起動し、配信           -> 7章参照
    |
【STEP 5】エンドユーザーがアプリケーションを利用       -> 8章参照
================================================================
```

### 11.1 【開発者】STEP1: プロジェクト作成

新しいプロジェクトを開始する際に実行します。

1. `npx create-next-app@latest` コマンドでプロジェクトを作成します
2. 対話的プロンプトでTypeScript、ESLint、Tailwind CSS等の設定を選択します
3. プロジェクトディレクトリに移動し、`next.config.js` で追加設定を行います
4. `.env.local` ファイルに環境変数を設定します
5. チームメンバーにプロジェクトの初期設定内容を共有します

### 11.2 【開発者】STEP2: 開発サーバーでの開発

日常的な開発作業の流れです。

1. `next dev` コマンドで開発サーバーを起動します（`--turbopack` オプション推奨）
2. ブラウザで `http://localhost:3000` にアクセスします
3. コードを編集し、HMRによる即時反映を確認します
4. エラーが発生した場合は、ブラウザ上のエラーオーバーレイを確認して修正します
5. DevToolsインジケーターでルート種別やエラー数を確認します
6. 必要に応じて `next lint` でコード品質をチェックします

### 11.3 【開発者】STEP3: ビルドと品質チェック

開発完了後、本番デプロイ前に実行します。

1. `next lint` でESLintチェックを実行します
2. `next build` でプロダクションビルドを実行します
3. ビルド結果を確認します（各ページのレンダリング種別、バンドルサイズ）
4. 必要に応じて `next start` でローカルの本番モードで動作確認します
5. 問題がなければデプロイの準備が完了です

### 11.4 【運用者】STEP4-5: 本番デプロイ・サーバー起動

本番環境へのデプロイと運用を行います。

1. ビルド済みアプリケーションを本番サーバーに配置します
2. `next start` コマンドでプロダクションサーバーを起動します
3. ヘルスチェックを行い、正常にレスポンスが返ることを確認します
4. 必要に応じて `--keepAliveTimeout` オプションでKeep-Aliveタイムアウトを調整します
5. エンドユーザーからのアクセスが正常に処理されることを確認します

---

## 12. よくある質問と対処法

### 12.1 開発環境に関するQ&A

**Q: 開発サーバーが起動しません**

A: 以下を確認してください：
- Node.jsのバージョンが20.9.0以上であること（`node -v` で確認）
- プロジェクトの依存関係がインストールされていること（`pnpm install` を実行）
- ポート3000が他のプロセスで使用されていないこと（`-p` オプションで別のポートを指定可能）
- 予約済みポートを指定していないこと

**Q: HMRが動作しません（コード変更が反映されません）**

A: 以下を確認してください：
- 開発サーバー（`next dev`）で起動していること（`next start` はHMR非対応）
- ファイルが正しく保存されていること
- `next.config.js` の変更はサーバーの再起動が必要です
- ブラウザのキャッシュをクリアしてみてください

**Q: TypeScriptの型エラーが表示されます**

A: 以下を確認してください：
- `tsconfig.json` が正しく設定されていること
- 必要な型定義パッケージがインストールされていること
- `next typegen` で型定義を再生成してみてください

### 12.2 ビルド・デプロイに関するQ&A

**Q: ビルドが失敗します**

A: 以下を確認してください：
- `next lint` でコードエラーがないか確認してください
- ビルドログのエラーメッセージを確認してください
- 環境変数が正しく設定されていること（特に `NEXT_PUBLIC_` プレフィックス付き変数）
- 依存パッケージのバージョンに互換性の問題がないか確認してください

**Q: 本番環境でページが正しく表示されません**

A: 以下を確認してください：
- `next build` が正常に完了していること
- 環境変数が本番環境に正しく設定されていること
- `basePath` の設定が正しいこと
- 画像の外部ドメインが `images` 設定に含まれていること

### 12.3 パフォーマンスに関するQ&A

**Q: ページの読み込みが遅い場合**

A: 以下を検討してください：
- `next/image` コンポーネントを使用して画像を最適化する
- `next/font` を使用してフォントを最適化する
- `next/dynamic` で不要なコンポーネントを遅延読み込みする
- バンドルサイズを `next analyze` で分析する
- 不要なクライアントサイドJavaScriptを削減する（Server Componentsの活用）

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| "This page could not be found." (404) | 指定されたURLに対応するページが存在しない | URLを確認する。ファイルシステムのルーティング規約に従ってページファイルが配置されているか確認する |
| "This page failed to load" (500) | サーバーサイドでエラーが発生した | サーバーログを確認する。データ取得処理やサーバーコンポーネントにエラーがないか確認する |
| "This page crashed" | クライアントサイドでランタイムエラーが発生した | 「Reload page」ボタンでリロードする。繰り返し発生する場合は管理者に連絡する |
| "You're not authorized to access this page." (401) | 認証されていない状態でアクセスした | ログインしてからアクセスする |
| "This page could not be accessed." (403) | アクセス権限がない | 管理者に権限の付与を依頼する |
| Port is already in use | 指定されたポートが使用中 | `-p` オプションで別のポートを指定する |
| Module not found | 依存モジュールが見つからない | `pnpm install` で依存関係を再インストールする |

### 13.2 よくあるトラブルと解決方法

**トラブル: 開発サーバーの起動が遅い**

解決方法：
- `--turbopack` オプションを使用してTurbopackバンドラーで高速化する
- 不要な依存パッケージを削除する
- `.next/` キャッシュディレクトリを削除して再ビルドする（`rm -rf .next`）

**トラブル: ビルド時にメモリ不足エラーが発生する**

解決方法：
- Node.jsのメモリ制限を増やす（`NODE_OPTIONS=--max-old-space-size=8192 next build`）
- 不要な依存パッケージやページを整理する
- Turbopackバンドラーの使用を検討する

**トラブル: 画像が表示されない**

解決方法：
- `next/image` コンポーネントを使用している場合、外部画像のドメインが `next.config.js` の `images.domains` に設定されていることを確認する
- 画像ファイルが `public/` ディレクトリに配置されていることを確認する
- 画像パスが正しいことを確認する

**トラブル: ハイドレーションエラーが発生する**

解決方法：
- サーバーとクライアントでレンダリング結果が一致しているか確認する
- `Date.now()` や `Math.random()` 等、サーバーとクライアントで異なる値を返す処理を避ける
- ブラウザ拡張機能がDOMを変更していないか確認する

### 13.3 サポートへの連絡方法

- **公式ドキュメント**: https://nextjs.org/docs
- **GitHub Issues**: https://github.com/vercel/next.js/issues
- **GitHub Discussions**: https://github.com/vercel/next.js/discussions
- **環境情報の確認**: `next info` コマンドで環境情報を出力し、問題報告時に添付してください

```
next info
```

このコマンドにより、Next.js・Node.js・OSのバージョン情報等が表示されます。

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-03 | 初版作成 |

---

*本マニュアルは、Next.jsフレームワークのエンドユーザー・開発者・運用者向け業務運用マニュアルです。*
*フレームワークの更新により、画面や操作方法が変更される場合があります。最新情報は公式ドキュメント（https://nextjs.org/docs）を参照してください。*
