---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 43
  claims_without_evidence: 7
confidence_derived: 0.86
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された非機能要件テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：43 / 50、根拠なし：7
- 優先レビュー（高）
  1. **NFT-005（同時接続負荷テスト）**：合格基準「100同時接続でエラー率1%未満」の数値根拠がコードから確認不可
  2. **NFT-001, NFT-002, NFT-003（レスポンス時間テスト）**：合格基準の具体的な数値はコード内に定義がなく、一般的なベストプラクティスに基づく
  3. **NFT-007（メモリリーク検出テスト）**：テスト期間「24時間以上」の根拠がコードから確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/config-shared.ts` - NextConfig型定義、ExperimentalConfig型定義
- E-02: `packages/next/src/server/image-optimizer.ts` - 画像最適化処理、Sharp並行度制御
- E-03: `packages/next/src/shared/lib/image-config.ts` - 画像設定デフォルト値（minimumCacheTTL、remotePatterns、dangerouslyAllowSVG等）
- E-04: `packages/next/src/server/app-render/csrf-protection.test.ts` - CSRF保護テスト実装
- E-05: `packages/next/src/server/lib/router-utils/block-cross-site.ts` - クロスサイトリクエストブロック実装
- E-06: `packages/next/src/server/app-render/encryption.ts` - Server Action暗号化処理
- E-07: `packages/next/src/client/trusted-types.ts` - Trusted Types Policy実装
- E-08: `packages/next/src/server/base-server.ts` - サーバー基盤処理
- E-09: `packages/next/src/server/serve-static.ts` - 静的ファイル配信
- E-10: `packages/next/src/server/api-utils/node/api-resolver.ts` - API Route解決処理
- E-11: `packages/next/src/server/lib/incremental-cache/` - ISRキャッシュ処理
- E-12: `packages/next/src/server/lib/etag.ts` - ETag生成処理
- E-13: `packages/next/src/server/is-private-ip.test.ts` - プライベートIP判定テスト
- E-14: `package.json` - Node.jsバージョン要件（>=20.9.0）、テストスクリプト定義
- E-15: `packages/next/src/server/web/adapter.ts` - Edge Runtime アダプタ
- E-16: `packages/next/src/server/load-default-error-components.ts` - エラーコンポーネント読込
- E-17: `bench/` - ベンチマーク用テストアプリケーション群
- E-18: `packages/next/src/server/send-payload.ts` - レスポンス送信・ETag処理
- E-19: `packages/next/src/server/pipe-readable.ts` - ストリーム圧縮処理
- E-20: `packages/next/src/build/webpack/plugins/subresource-integrity-plugin.ts` - SRIプラグイン（型参照確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SSRページレスポンス200ms/100ms以下 | E-08 | △ |
| C-02 | 静的ページレスポンス50ms以下 | E-09 | △ |
| C-03 | API Routeレスポンス200ms以下 | E-10 | △ |
| C-04 | 画像最適化レスポンス時間（初回500ms、キャッシュ50ms） | E-02, E-03 | ○ |
| C-05 | 100同時接続でエラー率1%未満 | - | △ |
| C-06 | 画像最適化同時処理がimgOptConcurrency設定で制御 | E-01, E-02 | ○ |
| C-07 | cacheMaxMemorySize 50MBデフォルト | E-01 | ○ |
| C-08 | ビルド時間の劣化検出 | E-17 | ○ |
| C-09 | staticGenerationMaxConcurrency設定による並行制御 | E-01 | ○ |
| C-10 | compress: trueでgzip圧縮が有効 | E-01, E-19 | ○ |
| C-11 | ISRキャッシュのrevalidate動作 | E-11 | ○ |
| C-12 | インメモリキャッシュ上限でエビクション | E-01 | ○ |
| C-13 | staleTimes設定によるクライアントキャッシュ制御 | E-01 | ○ |
| C-14 | turbopackTreeShakingによるバンドルサイズ削減 | E-01 | ○ |
| C-15 | optimizePackageImportsによる最適化 | E-01 | ○ |
| C-16 | turbopackMemoryLimit設定 | E-01 | ○ |
| C-17 | webpackMemoryOptimizations設定 | E-01 | ○ |
| C-18 | Server Action CSRF保護 | E-04, E-05 | ○ |
| C-19 | CSRFワイルドカードパターン | E-04 | ○ |
| C-20 | クロスサイトリクエストブロック（403） | E-05 | ○ |
| C-21 | Server Action引数暗号化 | E-06 | ○ |
| C-22 | Trusted Types Policy適用 | E-07 | ○ |
| C-23 | poweredByHeader: trueがデフォルト | E-01 | ○ |
| C-24 | remotePatterns: []でリモート画像拒否 | E-03 | ○ |
| C-25 | dangerouslyAllowSVG: false | E-03 | ○ |
| C-26 | 画像CSPデフォルト値 | E-03 | ○ |
| C-27 | SRI設定によるintegrityハッシュ付与 | E-01, E-20 | ○ |
| C-28 | プライベートIP制限 | E-02, E-13 | ○ |
| C-29 | リクエストボディサイズ制限 | E-01 | ○ |
| C-30 | maximumRedirects: 3 | E-03 | ○ |
| C-31 | カスタムエラーページ表示 | E-16 | ○ |
| C-32 | 未処理例外ハンドリング | E-01 | ○ |
| C-33 | ISR stale-while-revalidateパターン | E-11 | ○ |
| C-34 | lockDistDir: trueによるビルドロック | E-01 | ○ |
| C-35 | proxyTimeout設定によるタイムアウト | E-01 | ○ |
| C-36 | httpAgentOptions.keepAlive: true | E-01 | ○ |
| C-37 | Node.js >=20.9.0要件 | E-14 | ○ |
| C-38 | Edge Runtime互換性 | E-15 | ○ |
| C-39 | Turbopackビルド互換性 | E-14 | ○ |
| C-40 | Webpackビルド互換性 | E-14 | ○ |
| C-41 | Rspackビルド互換性 | E-14 | ○ |
| C-42 | ETag応答互換性 | E-01, E-12, E-18 | ○ |
| C-43 | i18nロケールルーティング | E-01 | ○ |
| C-44 | 画像フォーマット互換性（AVIF/WebP/PNG/JPEG） | E-02 | ○ |
| C-45 | ESLint静的解析 | E-14 | ○ |
| C-46 | TypeScript型チェック | E-14 | ○ |
| C-47 | Prettier書式チェック | E-14 | ○ |
| C-48 | AST Grep静的解析 | E-14 | ○ |
| C-49 | ユニットテスト実行 | E-14 | ○ |
| C-50 | E2Eテスト実行 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- **レスポンス時間の合格基準値（C-01, C-02, C-03）**: コード内にSLAやレスポンスタイム目標値の定義が存在しない。記載した数値は一般的なWebアプリケーションのベストプラクティスに基づく推定値。
  - 候補：プロジェクトのSLA定義書 / パフォーマンスバジェット設定 / モニタリングツールの閾値設定
- **同時接続数の合格基準（C-05）**: 100同時接続やエラー率1%未満の数値はコードから確認不可。
  - 候補：負荷テスト結果レポート / インフラキャパシティプランニング文書
- **メモリリーク検出テスト期間（C-07関連）**: 24時間という期間はコードに定義がなく、一般的なメモリリークテストの慣行に基づく。
  - 候補：運用テスト計画書 / SRE運用マニュアル

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: NFT-005（同時接続負荷テスト）- 合格基準の数値根拠が完全に欠落。プロジェクトの実際のSLA/KPIに基づいて調整が必要。
- **リスク1（中）**: NFT-001, NFT-002, NFT-003（レスポンス時間テスト）- 合格基準値は推定。実際のアプリケーション特性やインフラ構成により大幅に変動する可能性あり。
- **リスク1（中）**: NFT-007（メモリリーク検出テスト）- テスト期間の妥当性を要確認。
- **リスク0（低）**: セキュリティ関連テスト（NFT-018〜NFT-030）- コード内のテスト実装やデフォルト値で裏付けあり。
- **リスク0（低）**: 互換性テスト（NFT-037〜NFT-044）- package.jsonやテストスクリプトで裏付けあり。
- **リスク0（低）**: 保守性テスト（NFT-045〜NFT-050）- 既存のlintスクリプトやテストスクリプトで裏付けあり。

## 6) レビュアーチェックリスト（最小）
- [ ] レスポンス時間の合格基準値（NFT-001〜003）がプロジェクトの実際のSLA/パフォーマンスバジェットと一致しているか
- [ ] 同時接続負荷テスト（NFT-005）の合格基準がインフラ構成に適合しているか
- [ ] セキュリティテスト（NFT-018〜030）が組織のセキュリティポリシーを満たしているか
- [ ] 互換性テスト対象のNode.jsバージョンが運用環境のバージョンと一致しているか
- [ ] 画像最適化関連テスト（NFT-004, 024〜026, 030, 044）のデフォルト設定値がimage-config.tsの実装と一致しているか
- [ ] Turbopack/Webpack/Rspack各バンドラのテストケースがCI環境の構成と整合しているか
