---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 52
  claims_with_evidence: 48
  claims_without_evidence: 4
confidence_derived: 0.92
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された非機能要件定義書の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：48 / 52、根拠なし：4
- 優先レビュー（高）
  1. **可用性要件（稼働率・RTO・RPO）**：フレームワークのコードに明示的な定義がなく、インフラ依存として記載
  2. **レートリミット機能の不在**：コード検索で該当なし。フレームワークに内蔵されていないという主張の正確性
  3. **テレメトリ無効化方法**：`NEXT_TELEMETRY_DISABLED`はソースコード内の直接的な参照ではなくドキュメント知識に基づく
  4. **staticGenerationRetryCount のデフォルト挙動**：undefined時の実際のリトライ回数がコードから不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/server/config-shared.ts`（NextConfig型定義およびdefaultConfig）
- E-02: `packages/next/src/server/response-cache/index.ts`（レスポンスキャッシュの実装）
- E-03: `packages/next/src/server/lib/cache-handlers/default.ts`（デフォルトキャッシュハンドラー実装）
- E-04: `packages/next/src/server/image-optimizer.ts`（画像最適化処理）
- E-05: `packages/next/src/shared/lib/image-config.ts`（画像設定デフォルト値）
- E-06: `packages/next/src/server/lib/router-utils/proxy-request.ts`（プロキシリクエスト処理）
- E-07: `packages/next/src/telemetry/post-telemetry-payload.ts`（テレメトリ送信処理）
- E-08: `packages/next/src/server/lib/start-server.ts`（サーバー起動処理）
- E-09: `packages/next/src/lib/constants.ts`（定数定義）
- E-10: `packages/next/src/server/lib/trace/tracer.ts`（OpenTelemetryトレーサー）
- E-11: `packages/next/src/server/app-render/encryption.ts`（Server Action暗号化）
- E-12: `packages/next/src/server/lib/lru-cache.ts`（LRUキャッシュ実装）
- E-13: `packages/next/src/server/dev/log-requests.ts`（リクエストログ処理）
- E-14: `packages/next/src/server/lib/router-server.ts`（ルーターサーバー実装）
- E-15: `packages/next/src/server/lib/patch-fetch.ts`（fetch パッチ処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 静的ページ生成タイムアウトのデフォルト値は60秒 | E-01 (L1518) | ○ |
| C-02 | 画像最適化タイムアウトのデフォルト値は7秒 | E-01 (L1595) | ○ |
| C-03 | プロキシリクエストタイムアウトのデフォルト値は30秒 | E-06 (L32) | ○ |
| C-04 | テレメトリ送信タイムアウトは5秒 | E-07 (L19-20) | ○ |
| C-05 | プロセス検索タイムアウトは250ms | E-08 (L44) | ○ |
| C-06 | 静的生成最大同時実行数のデフォルトは8 | E-01 (L1640) | ○ |
| C-07 | 静的生成ワーカー当たり最小ページ数は25 | E-01 (L1641) | ○ |
| C-08 | CPUワーカー数はOSコア数-1（最小1） | E-01 (L1588-1592) | ○ |
| C-09 | 画像最適化の並行数はsharp依存で本番1/2、開発1/4に削減 | E-04 (L64-77) | ○ |
| C-10 | インメモリキャッシュ最大サイズのデフォルトは50MB | E-01 (L1483) | ○ |
| C-11 | レスポンスキャッシュTTLのデフォルトは10秒 | E-02 (L44-47) | ○ |
| C-12 | レスポンスキャッシュ最大エントリ数のデフォルトは150 | E-02 (L53-56) | ○ |
| C-13 | LRUキャッシュはサイズベースのLRU実装 | E-12 | ○ |
| C-14 | キャッシュライフプロファイル「default」のrevalidateは15分 | E-01 (L1529) | ○ |
| C-15 | キャッシュライフプロファイル「seconds」のrevalidateは1秒 | E-01 (L1534) | ○ |
| C-16 | キャッシュライフプロファイル「minutes」のrevalidateは1分 | E-01 (L1539) | ○ |
| C-17 | キャッシュライフプロファイル「hours」のrevalidateは1時間 | E-01 (L1544) | ○ |
| C-18 | キャッシュライフプロファイル「days」のrevalidateは1日 | E-01 (L1549) | ○ |
| C-19 | キャッシュライフプロファイル「weeks」のrevalidateは1週間 | E-01 (L1554) | ○ |
| C-20 | キャッシュライフプロファイル「max」のrevalidateは1ヶ月 | E-01 (L1559) | ○ |
| C-21 | staleTimes.dynamicのデフォルトは0秒 | E-01 (L1633) | ○ |
| C-22 | staleTimes.staticのデフォルトは300秒 | E-01 (L1634) | ○ |
| C-23 | 画像最小キャッシュTTLのデフォルトは14400秒（4時間） | E-05 (L157) | ○ |
| C-24 | オンデマンドエントリーの最大非アクティブ時間は60秒 | E-01 (L1496) | ○ |
| C-25 | オンデマンドエントリーのバッファ長は5 | E-01 (L1497) | ○ |
| C-26 | Turbopackファイルシステムキャッシュは開発モードで有効 | E-01 (L1653) | ○ |
| C-27 | Turbopackファイルシステムキャッシュはビルドモードで無効 | E-01 (L1654) | ○ |
| C-28 | キャッシュタグ最大数は128 | E-09 (L32) | ○ |
| C-29 | キャッシュタグ最大長は256文字 | E-09 (L33) | ○ |
| C-30 | expireTimeのデフォルトは31536000秒（1年） | E-01 (L1515-1517) | ○ |
| C-31 | INFINITE_CACHEの値は0xfffffffe | E-09 (L43) | ○ |
| C-32 | 可用性要件はフレームワークレベルで定義なし | **根拠なし** | △ |
| C-33 | HTTP Keep-Aliveはデフォルトで有効 | E-01 (L1508-1510) | ○ |
| C-34 | gzip圧縮はデフォルトで有効 | E-01 (L1490) | ○ |
| C-35 | 静的生成リトライ回数のデフォルトは未定義 | E-01 (L1638) | ○ |
| C-36 | テレメトリ送信リトライは最大1回 | E-07 (L37) | ○ |
| C-37 | デフォルトキャッシュのエラーリトライは3回 | E-03 (L27-30) | ○ |
| C-38 | lockDistDirのデフォルトは有効 | E-01 (L1649) | ○ |
| C-39 | Server ActionのAES暗号化 | E-11 | ○ |
| C-40 | 画像CSPのデフォルト値 | E-05 (L163) | ○ |
| C-41 | SVG許可のデフォルトは無効 | E-05 (L162) | ○ |
| C-42 | ローカルIP許可のデフォルトは無効 | E-05 (L161) | ○ |
| C-43 | リモートパターンのデフォルトは空配列 | E-05 (L166) | ○ |
| C-44 | x-powered-byのデフォルトは有効 | E-01 (L1489) | ○ |
| C-45 | ETag生成のデフォルトは有効 | E-01 (L1487) | ○ |
| C-46 | プロキシボディサイズ上限のデフォルトは10MB | E-01 (L1650) | ○ |
| C-47 | サーバーファンクションログのデフォルトは有効 | E-01 (L1512) | ○ |
| C-48 | テレメトリエンドポイントURL | E-07 (L25) | ○ |
| C-49 | OpenTelemetry統合のサポート | E-10 | ○ |
| C-50 | レートリミット機能はフレームワークに内蔵されていない | **根拠なし** | △ |
| C-51 | テレメトリ無効化は`NEXT_TELEMETRY_DISABLED`環境変数 | **根拠なし** | △ |
| C-52 | MCPサーバーのデフォルトは有効 | E-01 (L1652) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-32: 可用性要件（稼働率、RTO、RPO）はフレームワークのソースコードには明示的に定義されていない。フレームワークとしての性質上、これらはデプロイ先のインフラストラクチャに依存する。コード内に該当する定数や設定がないことは確認済みだが、「定義がない」という主張自体の完全な証明は困難。
  - 候補：Next.jsデプロイメントドキュメント / Vercelプラットフォーム仕様 / ユーザーアプリケーション要件
- C-50: レートリミット機能の不在はコード検索（`rateLimit`, `rate.limit`, `RateLimit`, `RATE_LIMIT`パターン）で該当なしであることから推定。ただし、全ファイルを網羅的に確認したわけではない。
  - 候補：Next.jsプラグインエコシステム / ミドルウェア実装パターン / Vercel Edge Functions
- C-51: `NEXT_TELEMETRY_DISABLED`環境変数は、Next.jsの公式ドキュメントおよびCLIヘルプに記載されているが、今回の解析対象ファイル群から直接的な参照は確認できていない。
  - 候補：`packages/next/src/telemetry/` ディレクトリの他ファイル / CLIコード / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - キャッシュ設定値（C-10〜C-31）：全てソースコードのデフォルト値から直接抽出しており、信頼性が高い
- 0: 低リスク - セキュリティ設定（C-39〜C-46）：ソースコードの実装から直接確認できる
- 1: 中リスク - 可用性要件の「定義なし」主張（C-32）：フレームワークの性質上妥当だが、将来のバージョンで変更される可能性がある
- 1: 中リスク - レートリミット機能の不在（C-50）：ミドルウェアやプロキシ機能での間接的な実装可能性を完全には排除できない
- 0: 低リスク - テレメトリ設定（C-48, C-36）：ソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] キャッシュ設定のデフォルト値が最新のソースコードと一致しているか確認
- [ ] 可用性要件について、アプリケーション固有の要件を追加する必要がないか確認
- [ ] レートリミットの要件がアプリケーションとして別途必要か検討
- [ ] `x-powered-by`ヘッダーの無効化が本番環境で適切に設定されているか確認
- [ ] テレメトリの有効/無効がプライバシー要件と整合しているか確認
- [ ] 画像最適化のセキュリティ設定（SVG許可、リモートパターン等）がアプリケーション要件と一致しているか確認
- [ ] Server Actionの暗号化キー管理が適切に行われているか確認
