# Node.js

## 概要

Node.jsは、オープンソースでクロスプラットフォームのJavaScriptランタイム環境です。V8 JavaScriptエンジンとlibuvイベントループライブラリを基盤として構築されており、サーバーサイドやコマンドラインツールでJavaScriptを実行することができます。OpenJS Foundationのサポートの下、オープンガバナンスモデルで運営されています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| イベント駆動I/O | libuvを利用した非同期、ノンブロッキングI/O処理 |
| V8エンジン | Googleの高性能JavaScript実行エンジンを採用 |
| 組み込みモジュール | fs, http, https, net, path, crypto等の豊富な標準ライブラリ |
| ES Modules / CommonJS | ESMとCommonJS両方のモジュールシステムをサポート |
| Worker Threads | マルチスレッド処理のサポート |
| Child Process | 子プロセスの生成と管理 |
| Stream API | 効率的なデータストリーミング処理 |
| Cluster | マルチコアCPUを活用したスケーリング |
| HTTP/2 / QUIC | 最新のHTTPプロトコルサポート |
| SQLite | 組み込みSQLiteデータベースサポート |
| パッケージマネージャ | npm, corepackによるパッケージ管理 |

## 技術スタック

### コア

- 言語: JavaScript (lib/), C++ (src/)
- JavaScript エンジン: V8
- イベントループ: libuv
- 暗号化: OpenSSL
- HTTP パーサー: llhttp
- DNS 解決: c-ares
- 圧縮: zlib, brotli, zstd
- URL パーサー: ada

### 主要ライブラリ

- **V8**: JavaScriptエンジン（Googleが開発）
- **libuv**: クロスプラットフォームの非同期I/Oライブラリ
- **OpenSSL**: TLS/SSL暗号化ライブラリ
- **llhttp**: 高速HTTPパーサー
- **c-ares**: 非同期DNS解決ライブラリ
- **ICU**: 国際化（i18n）サポートライブラリ
- **nghttp2**: HTTP/2実装
- **ngtcp2**: QUIC/HTTP/3実装
- **simdjson**: 高速JSONパーサー
- **SQLite**: 組み込みSQLデータベースエンジン
- **undici**: Node.js用HTTPクライアント
- **npm**: Node.jsパッケージマネージャ
- **corepack**: パッケージマネージャ管理ツール

## ディレクトリ構成

```
node-main/
├── lib/                    # JavaScript 組み込みモジュール
│   ├── internal/          # 内部モジュール
│   ├── fs.js              # ファイルシステムモジュール
│   ├── http.js            # HTTPサーバー/クライアント
│   ├── net.js             # ネットワーキングモジュール
│   ├── stream.js          # ストリームAPI
│   └── ...
├── src/                    # C++ ソースコード
│   ├── api/               # 公開API
│   ├── node.cc            # メインエントリポイント
│   └── ...
├── deps/                   # 外部依存ライブラリ
│   ├── v8/                # V8 JavaScriptエンジン
│   ├── uv/                # libuv イベントループ
│   ├── openssl/           # OpenSSL 暗号化
│   ├── npm/               # npm パッケージマネージャ
│   └── ...
├── test/                   # テストスイート
│   ├── parallel/          # 並列実行可能テスト
│   ├── sequential/        # 順次実行テスト
│   ├── cctest/            # C++テスト
│   └── ...
├── doc/                    # ドキュメント
├── tools/                  # ビルド・開発ツール
├── benchmark/              # パフォーマンスベンチマーク
├── configure.py            # ビルド設定スクリプト
├── Makefile               # ビルドメイクファイル
└── vcbuild.bat            # Windowsビルドスクリプト
```

## セットアップ

### 必要条件

- **Unix/macOS**:
  - Python 3.x
  - GCC 12.2以上 または Clang 19.1以上
  - macOS: Xcode 16.4以上
- **Windows**:
  - Visual Studio 2022
  - Windows 10 SDK
  - Python 3.x

### サポートプラットフォーム

| OS | アーキテクチャ | サポートレベル |
| --- | --- | --- |
| GNU/Linux | x64, arm64 | Tier 1 |
| Windows | x64 | Tier 1 |
| macOS | x64, arm64 | Tier 1 |
| Windows | arm64 | Tier 2 |
| GNU/Linux | ppc64le, s390x | Tier 2 |
| SmartOS, AIX | x64, ppc64be | Tier 2 |

### インストール手順

#### ソースからビルド (Unix/macOS)

```bash
# リポジトリをクローン
git clone https://github.com/nodejs/node.git
cd node

# 設定を実行
./configure

# ビルド
make -j4

# インストール (オプション)
sudo make install
```

#### ソースからビルド (Windows)

```batch
:: Visual Studio コマンドプロンプトから実行
vcbuild.bat
```

## 開発

### コードスタイル

- **JavaScript**: ESLint設定に従う (`eslint.config.mjs`)
- **C++**: clang-format設定に従う (`.clang-format`)
- **Python**: pyproject.toml設定に従う

### Linter

```bash
# JavaScript lint
make lint-js

# C++ lint
make lint-cpp

# 全体lint
make lint
```

### テスト実行

```bash
# 全テスト実行
make test

# 並列テストのみ
make test-parallel

# 特定テスト実行
python tools/test.py test/parallel/test-*.js

# C++テスト
make cctest
```

### ドキュメントビルド

```bash
# APIドキュメントをビルド
make doc

# ドキュメントテスト
make test-doc
```

### デバッグビルド

```bash
./configure --debug
make -j4
```

### ベンチマーク

```bash
# ベンチマーク実行
node benchmark/run.js
```
