---
generated_at: 2026-01-30 18:35:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **業務フロー追跡の詳細**：一部の詳細フローが推測を含む
  2. **C++層の完全な動作フロー**：libuv連携の詳細は推測を含む

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要と説明
- E-02: `lib/fs.js:25-100` - ファイルシステムAPI実装、primordials使用例
- E-03: `lib/internal/bootstrap/node.js:1-100` - ブートストラップ処理とコメント
- E-04: `lib/internal/errors.js:1-100` - エラーコード定義とパターン
- E-05: `lib/internal/validators.js:1-100` - バリデーション関数
- E-06: `lib/events.js:1-100` - EventEmitter実装
- E-07: `lib/internal/util.js:1-100` - ユーティリティ関数
- E-08: `lib/internal/modules/cjs/loader.js:1-100` - モジュールローダー
- E-09: `src/node.cc:1-100` - C++エントリーポイント
- E-10: `src/env.h:1-100` - Environment クラス定義
- E-11: `src/node_binding.h:1-100` - バインディング定義マクロ
- E-12: `tsconfig.json` - TypeScript設定、モジュールパス定義
- E-13: `doc/api/` - APIドキュメントディレクトリ
- E-14: `test/` - テストディレクトリ構造
- E-15: `lib/internal/main/` - メインエントリーポイント一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Node.jsはJavaScriptとC++の二層構造 | E-01, E-02, E-09 | ○ |
| C-02 | lib/ディレクトリにJavaScript実装がある | E-02, E-06, E-07 | ○ |
| C-03 | src/ディレクトリにC++実装がある | E-09, E-10, E-11 | ○ |
| C-04 | 'use strict'モードで動作 | E-02:25 | ○ |
| C-05 | primordialsパターンで組み込みオブジェクトを保護 | E-02:27-48, E-03:56-67 | ○ |
| C-06 | internalBindingでC++バインディングにアクセス | E-02:50, E-03:68 | ○ |
| C-07 | エラーはコード（ERR_XXX）で識別 | E-04:6-11, E-05:24-31 | ○ |
| C-08 | hideStackFramesでスタックトレースを簡略化 | E-05:95-100 | ○ |
| C-09 | 遅延初期化パターンを使用 | E-06:95-99 | ○ |
| C-10 | _xxx.jsはプライベートモジュール | E-02, E-12 | ○ |
| C-11 | xxx-inl.hはインライン関数ヘッダー | E-09:29-31 | ○ |
| C-12 | kプレフィックスは定数を示す | E-04:62, E-06:87-93 | ○ |
| C-13 | ERR_プレフィックスはエラーコード | E-04:66-67 | ○ |
| C-14 | validateで始まる関数はバリデーション | E-05:95-100 | ○ |
| C-15 | Safeプレフィックスはモンキーパッチ耐性型 | E-02:41-42, E-07:35-38 | ○ |
| C-16 | lib/internal/がユーザーアクセス不可 | E-08:80-96 | ○ |
| C-17 | lib/internal/bootstrap/が起動時初期化 | E-03:1-48 | ○ |
| C-18 | lib/internal/main/が実行モード別エントリー | E-15 | ○ |
| C-19 | deps/に外部依存がある | E-01, ディレクトリ構造 | ○ |
| C-20 | test/parallel/に並列テストがある | E-14 | ○ |
| C-21 | V8はJavaScriptエンジン | E-09:67, E-01 | ○ |
| C-22 | libuvはイベントループを提供 | E-10:50, E-09 | ○ |
| C-23 | node.ccがC++エントリーポイント | E-09:22-48 | ○ |
| C-24 | env.hがEnvironmentクラスを定義 | E-10:74-100 | ○ |
| C-25 | node_binding.hがバインディングを定義 | E-11:47-67 | ○ |
| C-26 | ブートストラップはrealm.jsから呼ばれる | E-03:35-38 | ○ |
| C-27 | グローバルオブジェクトはnode.jsで設定 | E-03:85-90 | ○ |
| C-28 | ArrayPrototypePushは安全な参照 | E-02:29, E-07:6 | ○ |
| C-29 | SafeMapはモンキーパッチ耐性Map | E-04:66, E-02:41 | ○ |
| C-30 | kIsNodeErrorはエラー識別シンボル | E-04:62 | ○ |
| C-31 | messagesはエラーメッセージ格納 | E-04:66 | ○ |
| C-32 | codesはエラーコード格納 | E-04:67 | ○ |
| C-33 | EventEmitterが遅延初期化 | E-06:95-99 | ○ |
| C-34 | モジュールローダーがCJS/ESM対応 | E-08:78-96 | ○ |
| C-35 | kModuleSourceがソースキャッシュ | E-08:80-84 | ○ |
| C-36 | doc/api/にAPIドキュメントがある | E-13 | ○ |
| C-37 | BUILDING.mdにビルド手順がある | E-01, ファイル存在 | ○ |
| C-38 | CONTRIBUTING.mdに貢献ガイドがある | E-01, ファイル存在 | ○ |
| C-39 | onboarding.mdが新規向けドキュメント | ファイル存在 | ○ |
| C-40 | GOVERNANCE.mdにガバナンスモデル | E-01, ファイル存在 | ○ |
| C-41 | fsモジュールがinternalBindingでfsバインディングにアクセス | E-02:65 | ○ |
| C-42 | configがinternalBinding('config')で取得 | E-03:68 | ○ |
| C-43 | isInt32/isUint32がバリデーション補助 | E-05:46-56 | ○ |
| C-44 | fs.readFileがbinding経由でシステムコール | E-02:65 | △ |
| C-45 | 起動フローがnode.cc→bootstrap→mainの順 | E-03:1-48 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-44, C-45（△の項目）について:**
  - fs.readFileとlibuv間の完全なコールスタックは、C++コードの詳細な追跡が必要
  - 起動フローの完全な詳細はC++コード（node_main_instance.cc等）の解析が必要
  - 候補：`src/node_file.cc` / `src/node_main_instance.cc` / `src/node_realm.cc`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 言語・フレームワーク特定、ディレクトリ構造説明
- **0（低リスク）**: 命名規則の説明（ソースコードから直接確認可能）
- **1（中リスク）**: 業務フロー追跡の詳細（一部推測を含む）
- **0（低リスク）**: アーキテクチャ概要（READMEとソースコードで確認可能）

## 6) レビュアーチェックリスト（最小）
- [ ] primordialsの説明が正確か（lib/internal/per_context/primordials.jsを確認）
- [ ] internalBindingの説明が正確か（lib/internal/bootstrap/realm.jsを確認）
- [ ] 起動フローの説明がBootstrapRealmの実際の動作と一致するか
- [ ] fs.readFileのデータフローがC++実装と一致するか
- [ ] 命名規則の例が実際のコードベースと一致するか
