# アーキテクチャ構成図

## 全体アーキテクチャ図

```mermaid
graph TB
    subgraph "User Application"
        UA[User JavaScript Code]
    end

    subgraph "JavaScript API Layer (lib/)"
        FS[fs.js]
        HTTP[http.js]
        NET[net.js]
        CRYPTO[crypto.js]
        EVENTS[events.js]
        STREAM[stream.js]
        BUFFER[buffer.js]
        CHILD[child_process.js]
        WORKER[worker_threads.js]
        TIMERS[timers.js]
    end

    subgraph "Internal JavaScript Layer (lib/internal/)"
        subgraph "Bootstrap"
            BOOT_NODE[bootstrap/node.js]
            BOOT_REALM[bootstrap/realm.js]
        end
        subgraph "Main Entry Points"
            MAIN_RUN[main/run_main_module.js]
            MAIN_WORKER[main/worker_thread.js]
            MAIN_REPL[main/repl.js]
        end
        subgraph "Module System"
            MOD_CJS[modules/cjs/loader.js]
            MOD_ESM[modules/esm/loader.js]
        end
        subgraph "Internal Utilities"
            INT_ERRORS[errors.js]
            INT_VALIDATORS[validators.js]
            INT_STREAMS[streams/]
            INT_CRYPTO[crypto/]
            INT_FS[fs/]
        end
    end

    subgraph "Binding Layer"
        INTERNAL_BINDING[internalBinding]
        PROCESS_BINDING[process.binding]
    end

    subgraph "C++ Core Layer (src/)"
        NODE_CC[node.cc]
        ENV_H[env.h / Environment]
        REALM_H[node_realm.h / Realm]
        ASYNC_WRAP[async_wrap.cc]
        BINDING_H[node_binding.h]
        subgraph "C++ Modules"
            FS_CC[fs_binding]
            HTTP_PARSER[http_parser_binding]
            CRYPTO_CC[crypto/]
            TCP_WRAP[tcp_wrap.cc]
            UDP_WRAP[udp_wrap.cc]
        end
    end

    subgraph "Dependencies Layer (deps/)"
        V8[V8 JavaScript Engine]
        LIBUV[libuv]
        OPENSSL[OpenSSL]
        LLHTTP[llhttp]
        NGHTTP2[nghttp2]
        NGTCP2[ngtcp2]
        CARES[c-ares]
        ICU[ICU]
        ZLIB[zlib]
        SQLITE[SQLite]
    end

    subgraph "Operating System"
        OS_FS[File System]
        OS_NET[Network Stack]
        OS_PROC[Process Management]
    end

    UA --> FS
    UA --> HTTP
    UA --> NET
    UA --> CRYPTO
    UA --> EVENTS
    UA --> STREAM
    UA --> BUFFER
    UA --> CHILD
    UA --> WORKER
    UA --> TIMERS

    FS --> INT_FS
    HTTP --> INT_STREAMS
    CRYPTO --> INT_CRYPTO
    STREAM --> INT_STREAMS

    INT_FS --> INTERNAL_BINDING
    INT_STREAMS --> INTERNAL_BINDING
    INT_CRYPTO --> INTERNAL_BINDING
    INT_ERRORS --> INTERNAL_BINDING

    BOOT_NODE --> BOOT_REALM
    BOOT_REALM --> INTERNAL_BINDING
    MAIN_RUN --> MOD_CJS
    MAIN_RUN --> MOD_ESM

    INTERNAL_BINDING --> BINDING_H
    PROCESS_BINDING --> BINDING_H

    BINDING_H --> NODE_CC
    BINDING_H --> ENV_H
    BINDING_H --> REALM_H
    BINDING_H --> ASYNC_WRAP

    NODE_CC --> FS_CC
    NODE_CC --> HTTP_PARSER
    NODE_CC --> CRYPTO_CC
    NODE_CC --> TCP_WRAP
    NODE_CC --> UDP_WRAP

    FS_CC --> LIBUV
    TCP_WRAP --> LIBUV
    UDP_WRAP --> LIBUV
    HTTP_PARSER --> LLHTTP
    CRYPTO_CC --> OPENSSL
    NODE_CC --> V8

    LIBUV --> OS_FS
    LIBUV --> OS_NET
    LIBUV --> OS_PROC
```

## レイヤー構成図

```mermaid
graph LR
    subgraph "Layer 1: Public API"
        L1[lib/*.js<br/>fs, http, net, crypto, etc.]
    end

    subgraph "Layer 2: Internal API"
        L2[lib/internal/**/*.js<br/>bootstrap, modules, streams, etc.]
    end

    subgraph "Layer 3: Binding"
        L3[internalBinding<br/>process.binding]
    end

    subgraph "Layer 4: C++ Core"
        L4[src/**/*.cc, *.h<br/>node.cc, env.h, etc.]
    end

    subgraph "Layer 5: Dependencies"
        L5[deps/**<br/>V8, libuv, OpenSSL, etc.]
    end

    L1 --> L2
    L2 --> L3
    L3 --> L4
    L4 --> L5
```

## ブートストラップシーケンス

```mermaid
sequenceDiagram
    participant OS as Operating System
    participant Main as node.cc (main)
    participant V8 as V8 Engine
    participant Realm as node_realm
    participant Bootstrap as bootstrap/node.js
    participant PreExec as pre_execution.js
    participant MainScript as main/*.js
    participant UserCode as User Code

    OS->>Main: node entry
    Main->>V8: Initialize V8
    Main->>Realm: Create Principal Realm
    Realm->>Bootstrap: BootstrapRealm()
    Bootstrap->>Bootstrap: setupProcessObject()
    Bootstrap->>Bootstrap: setupGlobalProxy()
    Bootstrap->>Bootstrap: setupBuffer()
    Bootstrap->>PreExec: prepareMainThreadExecution()
    PreExec->>PreExec: patchProcessObject()
    PreExec->>PreExec: setupDebugEnv()
    PreExec->>PreExec: initializeModuleLoaders()
    PreExec->>MainScript: Select main script
    MainScript->>UserCode: Execute user code
```

## モジュールシステム構成図

```mermaid
graph TB
    subgraph "Entry Points"
        REQUIRE[require()]
        IMPORT[import]
    end

    subgraph "Module Loaders"
        CJS_LOADER[CJS Loader<br/>modules/cjs/loader.js]
        ESM_LOADER[ESM Loader<br/>modules/esm/loader.js]
    end

    subgraph "Resolution"
        CJS_RESOLVE[CJS Resolution]
        ESM_RESOLVE[ESM Resolution]
        PKG_JSON[package_json_reader.js]
    end

    subgraph "Loading"
        CJS_COMPILE[CJS Compile]
        ESM_COMPILE[ESM Compile<br/>ModuleWrap]
    end

    subgraph "Cache"
        CJS_CACHE[Module._cache]
        ESM_CACHE[ModuleMap]
        RESOLVE_CACHE[ResolveCache]
        LOAD_CACHE[LoadCache]
    end

    REQUIRE --> CJS_LOADER
    IMPORT --> ESM_LOADER

    CJS_LOADER --> CJS_RESOLVE
    ESM_LOADER --> ESM_RESOLVE

    CJS_RESOLVE --> PKG_JSON
    ESM_RESOLVE --> PKG_JSON

    CJS_RESOLVE --> CJS_COMPILE
    ESM_RESOLVE --> ESM_COMPILE

    CJS_LOADER --> CJS_CACHE
    ESM_LOADER --> ESM_CACHE
    ESM_LOADER --> RESOLVE_CACHE
    ESM_LOADER --> LOAD_CACHE
```

## 非同期I/Oフロー図

```mermaid
sequenceDiagram
    participant JS as JavaScript
    participant Binding as Binding Layer
    participant CPP as C++ Core
    participant UV as libuv
    participant Pool as Thread Pool
    participant Kernel as OS Kernel

    JS->>Binding: fs.readFile(callback)
    Binding->>CPP: FSReqCallback
    CPP->>UV: uv_fs_read()
    UV->>Pool: Queue work
    Pool->>Kernel: read() syscall
    Kernel-->>Pool: Data
    Pool-->>UV: Work complete
    UV-->>CPP: Callback
    CPP-->>Binding: MakeCallback
    Binding-->>JS: callback(err, data)
```

## イベントループ構成図

```mermaid
graph TB
    subgraph "Event Loop Phases"
        TIMERS[Timers Phase<br/>setTimeout, setInterval]
        PENDING[Pending Callbacks<br/>Deferred I/O callbacks]
        IDLE[Idle, Prepare<br/>Internal use]
        POLL[Poll Phase<br/>Retrieve new I/O events]
        CHECK[Check Phase<br/>setImmediate]
        CLOSE[Close Callbacks<br/>socket.on close]
    end

    subgraph "Microtask Queue"
        NEXTTICK[process.nextTick]
        PROMISES[Promise callbacks]
    end

    TIMERS --> PENDING
    PENDING --> IDLE
    IDLE --> POLL
    POLL --> CHECK
    CHECK --> CLOSE
    CLOSE --> TIMERS

    TIMERS -.-> NEXTTICK
    PENDING -.-> NEXTTICK
    IDLE -.-> NEXTTICK
    POLL -.-> NEXTTICK
    CHECK -.-> NEXTTICK
    CLOSE -.-> NEXTTICK

    NEXTTICK --> PROMISES
```

## ストリームアーキテクチャ

```mermaid
classDiagram
    class EventEmitter {
        +on(event, listener)
        +emit(event, ...args)
        +removeListener(event, listener)
    }

    class Stream {
        +pipe(destination)
        +destroy()
    }

    class Readable {
        +read(size)
        +push(chunk)
        +_read(size)
        +pause()
        +resume()
    }

    class Writable {
        +write(chunk)
        +end()
        +_write(chunk, encoding, callback)
    }

    class Duplex {
    }

    class Transform {
        +_transform(chunk, encoding, callback)
        +_flush(callback)
    }

    class PassThrough {
    }

    EventEmitter <|-- Stream
    Stream <|-- Readable
    Stream <|-- Writable
    Readable <|-- Duplex
    Writable <|-- Duplex
    Duplex <|-- Transform
    Transform <|-- PassThrough
```

## 暗号化モジュール構成図

```mermaid
graph TB
    subgraph "JavaScript Layer"
        CRYPTO_JS[crypto.js]
        INT_CRYPTO_JS[internal/crypto/]
    end

    subgraph "C++ Crypto Modules"
        CRYPTO_UTIL[crypto_util.cc]
        CRYPTO_HASH[crypto_hash.cc]
        CRYPTO_CIPHER[crypto_cipher.cc]
        CRYPTO_SIG[crypto_sig.cc]
        CRYPTO_KEYS[crypto_keys.cc]
        CRYPTO_TLS[crypto_tls.cc]
        CRYPTO_X509[crypto_x509.cc]
        CRYPTO_RANDOM[crypto_random.cc]
    end

    subgraph "OpenSSL"
        EVP[EVP API]
        SSL[SSL/TLS API]
        BIGNUM[BIGNUM]
        X509_LIB[X509]
    end

    CRYPTO_JS --> INT_CRYPTO_JS
    INT_CRYPTO_JS --> CRYPTO_UTIL
    INT_CRYPTO_JS --> CRYPTO_HASH
    INT_CRYPTO_JS --> CRYPTO_CIPHER
    INT_CRYPTO_JS --> CRYPTO_SIG
    INT_CRYPTO_JS --> CRYPTO_KEYS
    INT_CRYPTO_JS --> CRYPTO_TLS
    INT_CRYPTO_JS --> CRYPTO_X509
    INT_CRYPTO_JS --> CRYPTO_RANDOM

    CRYPTO_HASH --> EVP
    CRYPTO_CIPHER --> EVP
    CRYPTO_SIG --> EVP
    CRYPTO_TLS --> SSL
    CRYPTO_KEYS --> EVP
    CRYPTO_KEYS --> BIGNUM
    CRYPTO_X509 --> X509_LIB
```

## 依存関係概要図

```mermaid
graph LR
    subgraph "Node.js Core"
        NODE[Node.js]
    end

    subgraph "JavaScript Engine"
        V8[V8]
    end

    subgraph "Async I/O"
        UV[libuv]
    end

    subgraph "HTTP"
        LLHTTP[llhttp]
        NGHTTP2[nghttp2]
        NGTCP2[ngtcp2/QUIC]
    end

    subgraph "Security"
        OPENSSL[OpenSSL]
        NCRYPTO[ncrypto]
    end

    subgraph "DNS"
        CARES[c-ares]
    end

    subgraph "Internationalization"
        ICU[ICU]
    end

    subgraph "Compression"
        ZLIB[zlib]
        BROTLI[Brotli]
        ZSTD[Zstandard]
    end

    subgraph "Data Processing"
        SQLITE[SQLite]
        SIMDJSON[simdjson]
        ADA[Ada/URL]
    end

    subgraph "Package Manager"
        NPM[npm]
        COREPACK[corepack]
    end

    NODE --> V8
    NODE --> UV
    NODE --> LLHTTP
    NODE --> NGHTTP2
    NODE --> NGTCP2
    NODE --> OPENSSL
    NODE --> NCRYPTO
    NODE --> CARES
    NODE --> ICU
    NODE --> ZLIB
    NODE --> BROTLI
    NODE --> ZSTD
    NODE --> SQLITE
    NODE --> SIMDJSON
    NODE --> ADA
    NODE --> NPM
    NODE --> COREPACK
```
