# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "開発者環境"
        DEV[開発者]
    end

    subgraph "GitHub"
        REPO[GitHubリポジトリ<br/>nodejs/node]

        subgraph "GitHub Actions"
            direction TB

            subgraph "Linux Runners"
                LINUX_X64[ubuntu-24.04<br/>x64]
                LINUX_ARM[ubuntu-24.04-arm<br/>arm64]
            end

            subgraph "macOS Runners"
                MACOS[macos-15]
            end

            subgraph "General Runners"
                UBUNTU_LATEST[ubuntu-latest]
            end
        end
    end

    subgraph "外部サービス"
        CODECOV[Codecov<br/>カバレッジレポート]
        SCCACHE[Mozilla sccache<br/>ビルドキャッシュ]
        NPM[npm Registry<br/>パッケージ]
        R2[Cloudflare R2<br/>リリースステージング]
    end

    DEV -->|push/PR| REPO
    REPO -->|trigger| LINUX_X64
    REPO -->|trigger| LINUX_ARM
    REPO -->|trigger| MACOS
    REPO -->|trigger| UBUNTU_LATEST

    LINUX_X64 -->|cache| SCCACHE
    LINUX_ARM -->|cache| SCCACHE
    MACOS -->|cache| SCCACHE

    LINUX_X64 -->|report| CODECOV
    LINUX_ARM -->|report| CODECOV

    LINUX_X64 -->|deps| NPM
    LINUX_ARM -->|deps| NPM
    MACOS -->|deps| NPM
    UBUNTU_LATEST -->|deps| NPM

    LINUX_X64 -.->|release| R2
```

## CI/CDパイプライン構成図

```mermaid
flowchart LR
    subgraph "トリガー"
        PR[Pull Request]
        PUSH[Push to main/v*.x]
        SCHEDULE[定期実行<br/>cron: 0 0 * * *]
    end

    subgraph "ワークフロー"
        direction TB

        subgraph "テストワークフロー"
            TEST_LINUX[test-linux.yml<br/>Linux テスト]
            TEST_MACOS[test-macos.yml<br/>macOS テスト]
            TARBALL[build-tarball.yml<br/>tarballビルド]
        end

        subgraph "品質ワークフロー"
            LINTERS[linters.yml<br/>静的解析]
            COVERAGE[coverage-linux.yml<br/>カバレッジ]
            CODEQL[codeql.yml<br/>セキュリティスキャン]
        end

        subgraph "その他"
            DAILY[daily.yml<br/>LTOビルド]
            DOC[doc.yml<br/>ドキュメント]
        end
    end

    subgraph "成果物"
        ARTIFACTS[GitHub Artifacts]
        CODECOV_REPORT[Codecov Report]
        SECURITY[Security Alerts]
    end

    PR --> TEST_LINUX
    PR --> TEST_MACOS
    PR --> TARBALL
    PR --> LINTERS
    PR --> COVERAGE

    PUSH --> TEST_LINUX
    PUSH --> TEST_MACOS
    PUSH --> LINTERS
    PUSH --> COVERAGE

    SCHEDULE --> CODEQL
    SCHEDULE --> DAILY

    TARBALL --> ARTIFACTS
    COVERAGE --> CODECOV_REPORT
    CODEQL --> SECURITY
```

## ビルドシステム構成図

```mermaid
flowchart TB
    subgraph "ビルド入力"
        SRC[ソースコード<br/>src/, lib/]
        DEPS[依存ライブラリ<br/>deps/]
        CONFIG[設定ファイル<br/>configure.py, node.gyp]
    end

    subgraph "ビルドツール"
        direction LR
        GYP[GYP<br/>ビルド定義生成]
        MAKE[Makefile<br/>Unix/Linux/macOS]
        VCBUILD[vcbuild.bat<br/>Windows]
        NINJA[Ninja<br/>高速ビルド]
    end

    subgraph "コンパイラ"
        CLANG[Clang 19<br/>Linux]
        GCC[GCC<br/>macOS]
        MSVC[MSVC<br/>Windows]
    end

    subgraph "出力"
        NODE_BIN[node バイナリ]
        NODE_LIB[libnode ライブラリ]
        TESTS[テストバイナリ]
    end

    SRC --> GYP
    DEPS --> GYP
    CONFIG --> GYP

    GYP --> MAKE
    GYP --> VCBUILD
    GYP --> NINJA

    MAKE --> CLANG
    MAKE --> GCC
    VCBUILD --> MSVC
    NINJA --> CLANG

    CLANG --> NODE_BIN
    GCC --> NODE_BIN
    MSVC --> NODE_BIN

    CLANG --> NODE_LIB
    GCC --> NODE_LIB
    MSVC --> NODE_LIB

    CLANG --> TESTS
    GCC --> TESTS
    MSVC --> TESTS
```

## 依存ライブラリ構成図

```mermaid
graph TB
    subgraph "Node.js Core"
        NODE[node]
    end

    subgraph "JavaScript Engine"
        V8[V8 Engine]
    end

    subgraph "ネットワーク/IO"
        LIBUV[libuv<br/>非同期I/O]
        LLHTTP[llhttp<br/>HTTP/1.1]
        NGHTTP2[nghttp2<br/>HTTP/2]
        NGTCP2[ngtcp2<br/>QUIC]
        CARES[c-ares<br/>DNS]
    end

    subgraph "暗号化"
        OPENSSL[OpenSSL<br/>TLS/暗号化]
        NCRYPTO[ncrypto<br/>暗号化ヘルパー]
    end

    subgraph "データ処理"
        ZLIB[zlib<br/>圧縮]
        ZSTD[zstd<br/>Zstandard]
        BROTLI[brotli<br/>Brotli圧縮]
        SIMDJSON[simdjson<br/>JSON]
        SQLITE[SQLite<br/>DB]
    end

    subgraph "パース/解析"
        ACORN[acorn<br/>JSパーサー]
        ADA[ada<br/>URLパーサー]
    end

    subgraph "国際化"
        ICU[ICU<br/>i18n]
    end

    subgraph "パッケージ管理"
        NPM_DEP[npm]
        COREPACK[corepack]
    end

    NODE --> V8
    NODE --> LIBUV
    NODE --> OPENSSL
    NODE --> LLHTTP
    NODE --> NGHTTP2
    NODE --> NGTCP2
    NODE --> CARES
    NODE --> ZLIB
    NODE --> ZSTD
    NODE --> BROTLI
    NODE --> ICU
    NODE --> SIMDJSON
    NODE --> SQLITE
    NODE --> ADA
    NODE --> ACORN
    NODE --> NPM_DEP
    NODE --> COREPACK
    NODE --> NCRYPTO
```

## テスト実行フロー

```mermaid
sequenceDiagram
    participant DEV as 開発者
    participant GH as GitHub
    participant GA as GitHub Actions
    participant CACHE as sccache
    participant CC as Codecov

    DEV->>GH: Push/PR作成
    GH->>GA: ワークフロー起動

    par Linux x64
        GA->>GA: Checkout
        GA->>GA: Install Clang 19
        GA->>GA: Install Rust 1.82
        GA->>GA: Setup Python 3.14
        GA->>CACHE: キャッシュ取得
        GA->>GA: Build (make build-ci -j4)
        GA->>GA: Test (make test-ci -j1)
    and Linux arm64
        GA->>GA: Checkout
        GA->>GA: Install Clang 19
        GA->>GA: Build & Test
    and macOS
        GA->>GA: Checkout
        GA->>GA: Setup Xcode 16.4
        GA->>GA: Build & Test
    end

    GA->>CC: カバレッジレポート送信
    GA->>GH: 結果報告
    GH->>DEV: ステータス通知
```

## セキュリティスキャン構成

```mermaid
graph LR
    subgraph "定期スキャン"
        CRON[毎日0:00 UTC]
    end

    subgraph "CodeQL分析"
        CPP[C++解析]
        JS[JavaScript解析]
        PY[Python解析]
    end

    subgraph "Linter"
        LINT_CPP[C++ Lint<br/>cpplint]
        LINT_JS[JavaScript Lint<br/>ESLint]
        LINT_PY[Python Lint<br/>Ruff]
        LINT_MD[Markdown Lint]
        LINT_YAML[YAML Lint]
        LINT_SH[Shell Lint<br/>shellcheck]
    end

    subgraph "結果"
        ALERTS[Security Alerts]
        SARIF[SARIF Report]
    end

    CRON --> CPP
    CRON --> JS
    CRON --> PY

    CPP --> ALERTS
    JS --> ALERTS
    PY --> ALERTS

    CPP --> SARIF
    JS --> SARIF
    PY --> SARIF
```
