# インフラ設計書

## 概要

本ドキュメントは、Node.jsプロジェクト（Node.jsランタイム本体のソースコード）のインフラストラクチャ構成を記載する。本プロジェクトはオープンソースのJavaScriptランタイムであり、主にGitHub Actionsを利用したCI/CDパイプラインで開発・テスト・ビルドが行われている。

## システム構成

### 全体構成

Node.jsプロジェクトは以下の構成要素で構成される：

1. **ソースコードリポジトリ**: GitHubでホストされるNode.jsのソースコード
2. **CI/CDパイプライン**: GitHub Actionsによる自動テスト・ビルド
3. **ビルドシステム**: GYP/Makefile/vcbuild.batによるクロスプラットフォームビルド
4. **依存ライブラリ**: V8、OpenSSL、libuv等の組み込み依存関係

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| GitHub Actions Runner (Linux) | ビルド・テスト実行 | ubuntu-24.04, ubuntu-24.04-arm | 複数（オンデマンド） |
| GitHub Actions Runner (macOS) | ビルド・テスト実行 | macos-15 | 複数（オンデマンド） |
| GitHub Actions Runner (Ubuntu Latest) | Linter・静的解析 | ubuntu-latest | 複数（オンデマンド） |

### ネットワーク構成

本プロジェクトはGitHubホスト型のCI/CDを使用しているため、専用のネットワーク構成は存在しない。以下の外部接続が発生する：

- GitHub Actions RunnerからGitHubリポジトリへのアクセス
- npm registryへのアクセス（依存パッケージ取得）
- Codecovへのカバレッジレポート送信
- sccacheによるビルドキャッシュアクセス

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Python | 3.14 | ビルドスクリプト実行、GYP実行 |
| Clang | 19 | C/C++コンパイル（Linux） |
| GCC | - | C/C++コンパイル（macOS） |
| Rust | 1.82 | Rustコンポーネントビルド |
| Xcode | 16.4 | macOSビルド環境 |
| sccache | v0.12.0 | コンパイラキャッシュ |
| Node.js | lts/* | ツール実行（Linter等） |
| ninja | - | 高速ビルド（LTOビルド時） |
| gcovr | 7.2 | C++カバレッジレポート生成 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理・CI/CD | HTTPS/SSH |
| GitHub Actions | CI/CDパイプライン | GitHub API |
| Codecov | コードカバレッジレポート | HTTPS API |
| Mozilla sccache | ビルドキャッシュ | HTTPS |
| npm Registry | パッケージ取得 | HTTPS |
| Cloudflare R2 | リリースステージング | r2:dist-staging |

## スケーリング設計

GitHub Actionsを利用したCI/CDのため、自動スケーリングはGitHubによって管理される。

- **並列実行**: `matrix`戦略による複数環境での並列テスト
  - Linux: ubuntu-24.04, ubuntu-24.04-arm
  - macOS: macos-15
- **同時実行制御**: `concurrency`設定により同一ワークフロー・ブランチでの重複実行を防止
  - キャンセル機能: `cancel-in-progress: true`で新しい実行時に古い実行をキャンセル
- **ジョブ並列数**: テストは`-j4`（ビルド）、`-j1`（テスト実行）で制御

## 可用性設計

GitHub Actionsの可用性に依存する。

- **フェイルファスト無効化**: `fail-fast: false`設定により、一部の環境でテストが失敗しても他環境のテストを継続
- **Flaky Tests対応**: `FLAKY_TESTS: keep_retrying`設定により不安定なテストを再試行
- **フレキネス計測**: `--measure-flakiness 9`オプションでテストの不安定性を計測
- **Draft PR対応**: ドラフトPRでは自動テストをスキップしリソースを節約

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Gitリポジトリ | リアルタイム | 無期限 |
| ビルド成果物 | GitHub Artifacts | ワークフロー実行毎 | デフォルト保持期間 |
| ビルドキャッシュ | sccache GHA | ワークフロー実行毎 | GHA設定依存 |

## 監視設計

### CI/CD監視

- **GitHub Actions**: ワークフロー実行状況・失敗通知
- **Codecov**: コードカバレッジ監視・閾値チェック
- **CodeQL**: セキュリティ脆弱性スキャン（毎日0時実行）
- **Scorecard**: セキュリティベストプラクティス評価

### 定期実行ジョブ

| ジョブ名 | スケジュール | 用途 |
| --- | --- | --- |
| Node.js daily job | 毎日0時 | LTOビルドテスト |
| CodeQL | 毎日0時 | セキュリティスキャン |
| Daily WPT FYI | 毎日 | Web Platform Tests |
| Close stale PRs | 定期 | 古いPRのクローズ |
| Find inactive collaborators | 定期 | 非アクティブコラボレーター検出 |

## 依存ライブラリ（組み込み）

| ライブラリ名 | 用途 |
| --- | --- |
| V8 | JavaScriptエンジン |
| OpenSSL | 暗号化・TLS |
| libuv | 非同期I/O |
| llhttp | HTTP/1.1パーサー |
| nghttp2 | HTTP/2実装 |
| ngtcp2 | QUIC実装 |
| c-ares | 非同期DNSリゾルバ |
| zlib | データ圧縮 |
| zstd | Zstandard圧縮 |
| brotli | Brotli圧縮 |
| sqlite | SQLiteデータベース |
| ICU | 国際化（i18n） |
| npm | パッケージマネージャ |
| acorn | JavaScriptパーサー |
| simdjson | 高速JSONパーサー |
| ada | URLパーサー |
| LIEF | バイナリ解析 |

## ビルド環境

### 開発用Dockerfile

プロジェクト内に以下のDockerfileが存在する：

1. **deps/openssl/config/Dockerfile**: OpenSSL設定生成用
   - ベースイメージ: ubuntu:22.04
   - 用途: OpenSSL構成ファイルの生成

2. **deps/ngtcp2/ngtcp2/third-party/urlparse/.clusterfuzzlite/Dockerfile**: Fuzzテスト用
   - ベースイメージ: gcr.io/oss-fuzz-base/base-builder:v1
   - 用途: ClusterFuzzLiteによるファジング

### ビルドシステム

| ファイル | 対象OS | 用途 |
| --- | --- | --- |
| configure.py | Unix/Linux/macOS | ビルド構成スクリプト |
| Makefile | Unix/Linux/macOS | ビルド実行 |
| vcbuild.bat | Windows | ビルド実行 |
| node.gyp | 全OS | GYPビルド定義 |

### サポートOS/アーキテクチャ

| OS | アーキテクチャ |
| --- | --- |
| Linux | x64, arm64 |
| macOS | x64, arm64 |
| Windows | x64, x86, arm64 |
| AIX | ppc64 |
| FreeBSD | x64 |
| SmartOS/Solaris | x64 |

## 備考

- 本プロジェクトはNode.jsランタイムのソースコードであり、アプリケーション用のデプロイインフラではなくビルド・テストインフラが中心となる
- 本番環境へのデプロイはユーザーが各自の環境で行う
- リリースビルドは別途nodejs.orgのリリースインフラで行われる
- Windows用のビルドはvcbuild.bat、Unix系はMakefileを使用する
- GitHub Actionsのワークフローはプルリクエストとpushイベントで自動実行される
