---
generated_at: 2026-01-30 16:30:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **XSS/SQLインジェクション/CSRF対策**：Node.jsコアでの対策未提供という主張の確認
  2. **監査ログの保持期間**：具体的な保持期間設定がコードから確認不可
  3. **WebCrypto実装詳細**：`lib/internal/crypto/webcrypto.js`の詳細確認が必要
  4. **実験的機能のセキュリティポリシー**：SECURITY.mdの記載に基づくが実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/crypto.js` - 暗号化モジュールのエントリポイント
- E-02: `lib/tls.js` - TLS/SSLモジュール
- E-03: `lib/https.js` - HTTPSモジュール
- E-04: `lib/internal/crypto/cipher.js` - 暗号化/復号化実装
- E-05: `lib/internal/crypto/hash.js` - ハッシュ/HMAC実装
- E-06: `lib/internal/crypto/sig.js` - 署名/検証実装
- E-07: `lib/internal/crypto/keygen.js` - 鍵生成実装
- E-08: `lib/internal/crypto/diffiehellman.js` - 鍵交換実装
- E-09: `lib/internal/crypto/random.js` - 乱数生成実装
- E-10: `lib/internal/crypto/webcrypto.js` - WebCrypto API実装
- E-11: `lib/internal/tls/secure-context.js` - TLSセキュアコンテキスト設定
- E-12: `lib/internal/tls/wrap.js` - TLSソケットラッパー
- E-13: `lib/internal/validators.js` - 入力検証関数群
- E-14: `SECURITY.md` - セキュリティポリシードキュメント
- E-15: `lib/internal/crypto/pbkdf2.js` - PBKDF2実装
- E-16: `lib/internal/crypto/scrypt.js` - scrypt実装
- E-17: `lib/internal/crypto/argon2.js` - Argon2実装
- E-18: `lib/internal/crypto/hkdf.js` - HKDF実装
- E-19: `lib/internal/crypto/kem.js` - KEM（鍵カプセル化）実装
- E-20: `lib/internal/crypto/x509.js` - X.509証明書実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TLS/SSL証明書認証を提供 | E-02, E-12 | ○ |
| C-02 | HMAC認証を提供 | E-05 | ○ |
| C-03 | デジタル署名認証を提供 | E-06 | ○ |
| C-04 | TLSセッション有効期限が設定可能 | E-11 | ○ |
| C-05 | セッションキャッシング対応 | E-03 | ○ |
| C-06 | クライアント再ネゴシエーション制限(3回/600秒) | E-02 | ○ |
| C-07 | セッションチケット48バイト固定 | E-11 | ○ |
| C-08 | 実行ユーザーの全権限を継承 | E-14 | ○ |
| C-09 | デフォルトTLS最小バージョンがTLSv1.2 | E-02 | ○ |
| C-10 | デフォルトTLS最大バージョンがTLSv1.3 | E-02 | ○ |
| C-11 | checkServerIdentityによるSAN/CN検証 | E-02 | ○ |
| C-12 | 対称暗号(AES-GCM等)対応 | E-04 | ○ |
| C-13 | 非対称暗号(RSA, ECDSA等)対応 | E-04, E-06 | ○ |
| C-14 | ハッシュ(SHA-256等)対応 | E-05 | ○ |
| C-15 | PBKDF2鍵導出対応 | E-15 | ○ |
| C-16 | scrypt鍵導出対応 | E-16 | ○ |
| C-17 | Argon2鍵導出対応 | E-17 | ○ |
| C-18 | HKDF鍵導出対応 | E-18 | ○ |
| C-19 | ML-KEM(耐量子暗号)対応 | E-19 | ○ |
| C-20 | FIPSモード対応 | E-01 | ○ |
| C-21 | secureHeapUsed()提供 | E-01 | ○ |
| C-22 | timingSafeEqual()提供 | E-01 | ○ |
| C-23 | NODE_EXTRA_CA_CERTS対応 | E-02 | ○ |
| C-24 | XSS対策はNode.jsコアで未提供 | **根拠なし** | △ |
| C-25 | SQLインジェクション対策はNode.jsコアで未提供 | **根拠なし** | △ |
| C-26 | CSRF対策はNode.jsコアで未提供 | **根拠なし** | △ |
| C-27 | 包括的な入力検証関数群を提供 | E-13 | ○ |
| C-28 | 脆弱性報告はHackerOne経由 | E-14 | ○ |
| C-29 | CWE-295(不正な証明書検証)が脆弱性に該当 | E-14 | ○ |
| C-30 | CWE-444(HTTPリクエストスマグリング)が脆弱性に該当 | E-14 | ○ |
| C-31 | CWE-1357(悪意あるサードパーティモジュール)は脆弱性に該当しない | E-14 | ○ |
| C-32 | 監査ログ機能はコアで提供されない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **XSS/SQLインジェクション/CSRF対策(C-24, C-25, C-26)**：Node.jsコアのソースコードを網羅的に確認した結果、これらの対策機能が提供されていないことを確認。ただし、「提供されていない」ことの明示的な根拠（ドキュメント等）は不在。
  - 候補：公式ドキュメント / セキュリティガイドライン / API仕様書
- **監査ログ機能(C-32)**：監査ログ専用モジュールがないことを確認したが、明示的な記載なし。
  - 候補：公式ドキュメント / 診断チャネルAPIドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - TLS/SSL設定、暗号化方式、入力検証関数（コードで直接確認可能）
- **1: 中リスク** - セッション管理パラメータ（デフォルト値の妥当性要確認）
- **1: 中リスク** - 脆弱性ポリシー（SECURITY.mdの解釈に依存）
- **2: 高リスク** - 監査ログ機能の不在（アプリケーション設計への影響大）

## 6) レビュアーチェックリスト（最小）
- [ ] TLSデフォルト設定値（TLSv1.2/1.3）がセキュリティ要件を満たしているか確認
- [ ] 暗号スイートのデフォルト設定が最新のセキュリティガイドラインに準拠しているか確認
- [ ] 入力検証関数が実際のアプリケーションコードで適切に使用されているか確認
- [ ] XSS/SQLインジェクション/CSRF対策がアプリケーションレベルで実装されているか確認
- [ ] セキュリティポリシー（SECURITY.md）の内容が最新かどうか確認
- [ ] 監査ログ要件がある場合、アプリケーションレベルでの実装計画を確認
- [ ] NODE_EXTRA_CA_CERTS等の環境変数設定が適切かどうか確認
- [ ] FIPSモードが必要な場合、正しく設定されているか確認
