---
generated_at: 2026-01-30 16:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **担当者の記載**：組織体制に関する根拠が不足
  2. **性能テストの閾値**：具体的な目標値の根拠が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `Makefile` - テスト実行コマンド、カバレッジ設定
- E-02: `.github/workflows/test-linux.yml` - Linux CI設定
- E-03: `.github/workflows/test-macos.yml` - macOS CI設定
- E-04: `.github/workflows/coverage-linux.yml` - カバレッジCI設定
- E-05: `.github/workflows/linters.yml` - Linter CI設定
- E-06: `.nycrc` - JavaScript カバレッジ目標設定
- E-07: `codecov.yml` - Codecov設定
- E-08: `test/README.md` - テストディレクトリ説明
- E-09: `test/common/README.md` - テストヘルパー説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tools/test.pyがテストランナーとして使用される | E-01, E-02 | ○ |
| C-02 | cctestがC++テストに使用される（Google Testベース） | E-01 | ○ |
| C-03 | c8がJavaScriptカバレッジツールとして使用される | E-01, E-04 | ○ |
| C-04 | gcovrがC++カバレッジツールとして使用される（v7.2） | E-01, E-04 | ○ |
| C-05 | ESLintがJavaScript Linterとして使用される | E-01, E-05 | ○ |
| C-06 | cpplintがC++ Linterとして使用される | E-01, E-05 | ○ |
| C-07 | ruffがPython Linterとして使用される（v0.13.1） | E-01, E-05 | ○ |
| C-08 | yamllintがYAML Linterとして使用される | E-01, E-05 | ○ |
| C-09 | Valgrindによるメモリリーク検出が可能 | E-01 | ○ |
| C-10 | sccacheがコンパイルキャッシュとして使用される（v0.12.0） | E-02, E-03 | ○ |
| C-11 | JavaScript行カバレッジ目標は95% | E-06 | ○ |
| C-12 | JavaScript分岐カバレッジ目標は93% | E-06 | ○ |
| C-13 | JavaScriptステートメントカバレッジ目標は95% | E-06 | ○ |
| C-14 | Linux CI環境はUbuntu 24.04（x64/ARM64） | E-02 | ○ |
| C-15 | Linux CIはClang 19を使用 | E-02 | ○ |
| C-16 | Linux CIはPython 3.14を使用 | E-02, E-03 | ○ |
| C-17 | Linux CIはRust 1.82を使用 | E-02 | ○ |
| C-18 | macOS CIはmacos-15で実行 | E-03 | ○ |
| C-19 | macOS CIはXcode 16.4を使用 | E-03 | ○ |
| C-20 | test/parallelがCIで実行される | E-08 | ○ |
| C-21 | test/internetはCIでは実行されない | E-08 | ○ |
| C-22 | FLAKY_TESTS=keep_retryingで不安定テストを再試行 | E-02, E-03 | ○ |
| C-23 | フレーキー度測定は--measure-flakiness 9で実行 | E-02, E-03 | ○ |
| C-24 | テストヘルパーにmustCall, expectWarning等が含まれる | E-09 | ○ |
| C-25 | test/fixturesにテストフィクスチャが配置 | E-08 | ○ |
| C-26 | Codecovにカバレッジがアップロードされる | E-04, E-07 | ○ |
| C-27 | 担当が「開発者」「QA」「CI/CD自動実行」に分かれる | **根拠なし** | △ |
| C-28 | 性能テストは「定期実行・必要に応じて」実施 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **担当者・組織体制**：プロジェクトのテスト担当者の明確な定義がコードベースから抽出できない。Node.jsはOSSプロジェクトのため、コントリビューター全員がテスト担当となる可能性が高い。
  - 候補：CONTRIBUTING.md / GOVERNANCE.md / チームドキュメント
- **性能テストの具体的な実施タイミング**：ベンチマークの定期実行スケジュールがワークフローから明確に確認できない。
  - 候補：.github/workflows/daily.yml / benchmark/README.md

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - テストツール・フレームワークの情報（設定ファイルから直接確認可能）
- **0: 低リスク** - カバレッジ目標値（.nycrcから直接確認）
- **0: 低リスク** - CI環境情報（GitHub Actionsワークフローから確認）
- **1: 中リスク** - 担当者・組織に関する記載（推測に基づく）
- **1: 中リスク** - テスト実施タイミングの一部（明確な定義がない項目）

## 6) レビュアーチェックリスト（最小）

- [ ] テストディレクトリ構成がtest/README.mdの内容と一致しているか
- [ ] カバレッジ目標値が.nycrcの値と一致しているか
- [ ] CI環境のバージョン情報がワークフローファイルと一致しているか
- [ ] テストツールのバージョン情報が最新か確認
- [ ] 「担当」列の内容がプロジェクトの実態と合っているか確認（OSSのため曖昧な可能性）
- [ ] Windowsテスト環境の詳細が必要な場合は別途調査
