# テスト方針書

## 概要

本ドキュメントは、Node.jsプロジェクトのテスト方針を定義する。Node.jsは複数の言語（JavaScript、C++、Python）で構成されるランタイムプラットフォームであり、包括的なテスト戦略により品質を担保している。テストは並列実行を基本とし、CI/CDパイプラインを通じて継続的に実行される。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のモジュール・関数の動作検証 | 開発者（JavaScript/C++） |
| 結合テスト | モジュール間の連携検証、API動作検証 | 開発者/QA |
| システムテスト | ランタイム全体としての動作検証 | CI/CD自動実行 |
| 受入テスト | Web Platform Tests (WPT) による標準準拠検証 | CI/CD自動実行 |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | Node.js API・コアモジュールの機能検証 | PR作成時・マージ時 |
| 性能テスト | ベンチマーク実行によるパフォーマンス検証 | 定期実行・必要に応じて |
| セキュリティテスト | CodeQL静的解析 | PR作成時・定期実行 |
| 回帰テスト | 既知の問題の再発防止 | CI実行時 |
| インターネットテスト | ネットワーク接続を要するテスト | 手動実行・必要に応じて |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| Linux (Ubuntu 24.04) | メインCI環境（x64/ARM64） | Clang 19、Python 3.14、Rust 1.82 |
| macOS (macos-15) | macOS CI環境 | Xcode 16.4、GCC、Python 3.14 |
| Windows | Windows CI環境 | MSVC、Python |
| ローカル開発環境 | 開発者による手動テスト | 各種OS対応 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| tools/test.py | テストランナー（Python製） | 内蔵ツール |
| cctest | C++単体テスト（Google Testベース） | 内蔵ツール |
| c8 | JavaScriptコードカバレッジ | npm依存 |
| gcovr | C++コードカバレッジ | 7.2 |
| ESLint | JavaScript静的解析/Linter | npm依存 |
| cpplint | C++静的解析/Linter | 内蔵ツール |
| ruff | Python静的解析/Linter | 0.13.1 |
| yamllint | YAML静的解析/Linter | pip依存 |
| Valgrind | メモリリーク検出 | システム依存 |
| sccache | コンパイルキャッシュ | v0.12.0 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ（JavaScript） | 95% |
| 分岐カバレッジ（JavaScript） | 93% |
| ステートメントカバレッジ（JavaScript） | 95% |
| C++カバレッジ | 測定・報告（閾値なし） |

## テストデータ

### テストディレクトリ構成

| ディレクトリ | CI実行 | 目的 |
| --- | --- | --- |
| test/parallel | Yes | 並列実行可能なテスト群（主要テストスイート） |
| test/sequential | Yes | 逐次実行が必要なテスト群 |
| test/cctest | Yes | C++単体テスト |
| test/addons | Yes | ネイティブアドオンテスト |
| test/js-native-api | Yes | JS Native APIテスト |
| test/node-api | Yes | Node-APIテスト |
| test/async-hooks | Yes | async_hooks機能テスト |
| test/es-module | Yes | ESモジュールローディングテスト |
| test/wpt | Yes | Web Platform Testsテスト |
| test/benchmark | Yes | ベンチマークの最小機能テスト |
| test/internet | No | 外部ネットワーク接続テスト |
| test/pummel | No | 負荷テスト |
| test/known_issues | Yes | 既知の問題の再現テスト |

### テストフィクスチャ

- `test/fixtures/`: テストで使用する固定データファイル
- `test/common/`: テスト共通モジュール群

### テストヘルパー

`test/common/` ディレクトリに以下の主要ヘルパーモジュールが含まれる：

- **common.js**: 基本的なテストユーティリティ（`mustCall`、`expectWarning`等）
- **fixtures.js**: フィクスチャファイルアクセス
- **tmpdir.js**: テスト用一時ディレクトリ管理
- **http2.js**: HTTP/2モックフレーム生成
- **countdown.js**: カウントダウン機構
- **gc.js**: ガベージコレクション監視

## 不具合管理

- **GitHub Issues**: 不具合報告・追跡
- **Flaky Tests**: `--flaky-tests keep_retrying` オプションによる不安定テストの再試行
- **Known Issues**: `test/known_issues/` に既知問題の再現テストを配置
- **Status Files**: 各テストディレクトリの `.status` ファイルでテスト除外・スキップを管理

## CI/CD連携

### GitHub Actions ワークフロー

| ワークフロー | トリガー | 目的 |
| --- | --- | --- |
| test-linux.yml | PR/Push | Linux環境でのビルド・テスト実行 |
| test-macos.yml | PR/Push | macOS環境でのビルド・テスト実行 |
| coverage-linux.yml | PR/Push | コードカバレッジ測定・Codecovへのアップロード |
| linters.yml | PR/Push | 各種Linter実行 |
| codeql.yml | 定期実行 | セキュリティ静的解析 |
| daily.yml | 定期実行 | デイリービルド・テスト |

### テスト実行コマンド

```bash
# 全テスト実行
make test

# テストのみ実行（Linter/ドキュメント除外）
make test-only

# CI用テスト実行
make test-ci

# カバレッジテスト実行
make coverage

# C++テスト実行
make cctest

# JavaScriptテスト実行
make jstest

# V8テスト実行
make test-v8

# Linter実行
make lint
```

### フレーキーテスト対応

- 環境変数 `FLAKY_TESTS=keep_retrying` により不安定テストを最大9回まで再試行
- `--measure-flakiness 9` オプションでフレーキー度を測定

### テスト結果出力

- TAP形式でのログ出力（`test.tap`）
- JUnit XML形式でのレポート出力（`out/junit/`）
- Codecovへのカバレッジレポートアップロード

## 備考

### テスト作成ガイドライン

1. 全テストは `require('../common')` で開始すること
2. テストファイル名は `test-` プレフィックスを使用
3. 並列実行可能なテストは `test/parallel/` に配置
4. 特定の実行フラグが必要な場合は `// Flags: --flag-name` コメントで指定
5. テストは独立して実行可能であること（副作用を残さない）

### 環境変数

- `NODE_COMMON_PORT`: テスト用ポート番号の上書き
- `NODE_SKIP_CRYPTO`: 暗号化テストのスキップ
- `NODE_TEST_KNOWN_GLOBALS`: 許可するグローバル変数のリスト
- `NODE_V8_COVERAGE`: カバレッジ出力ディレクトリ指定
