# ER図

## Web Storage データベーススキーマ

```mermaid
erDiagram
    nodejs_webstorage {
        BLOB key PK "NOT NULL - ストレージキー(UTF-16LE)"
        BLOB value "NOT NULL - ストレージ値(UTF-16LE)"
    }

    nodejs_webstorage_state {
        INTEGER single_row_ PK "NOT NULL DEFAULT 1 CHECK(=1) - シングルトン制約"
        INTEGER max_size "NOT NULL DEFAULT 10485760 - 最大容量(バイト)"
        INTEGER total_size "NOT NULL - 現在使用量(バイト)"
        INTEGER schema_version "NOT NULL DEFAULT 0 - スキーマバージョン"
    }

    nodejs_webstorage_state ||--o{ nodejs_webstorage : "quota_management"
```

## 関係性の説明

| 関係 | 説明 |
| --- | --- |
| nodejs_webstorage_state -> nodejs_webstorage | `nodejs_webstorage_state`テーブルは`nodejs_webstorage`テーブルのクォータ（容量制限）を管理します。トリガーを通じて`nodejs_webstorage`テーブルへのINSERT/UPDATE/DELETE操作が監視され、`total_size`が更新されます |

## トリガーによる連携フロー

```mermaid
flowchart TD
    A[INSERT into nodejs_webstorage] --> B[nodejs_quota_insert トリガー]
    B --> C[total_size を加算]
    C --> D{total_size > max_size?}
    D -->|Yes| E[ABORT - QuotaExceeded]
    D -->|No| F[INSERT 成功]

    G[UPDATE nodejs_webstorage] --> H[nodejs_quota_update トリガー]
    H --> I[total_size を差分更新]
    I --> J{total_size > max_size?}
    J -->|Yes| K[ABORT - QuotaExceeded]
    J -->|No| L[UPDATE 成功]

    M[DELETE from nodejs_webstorage] --> N[nodejs_quota_delete トリガー]
    N --> O[total_size を減算]
    O --> P[DELETE 成功]
```

## node:sqlite モジュールのクラス構造

`node:sqlite`モジュールは固定のデータベーススキーマを持たないため、ER図ではなくクラス図で表現します。

```mermaid
classDiagram
    class DatabaseSync {
        +String path
        +Boolean isOpen
        +Boolean isTransaction
        +open()
        +close()
        +exec(sql)
        +prepare(sql, options) StatementSync
        +function(name, options, func)
        +aggregate(name, options)
        +createSession(options) Session
        +createTagStore(maxSize) SQLTagStore
        +applyChangeset(changeset, options)
        +loadExtension(path)
        +enableLoadExtension(allow)
        +enableDefensive(active)
        +setAuthorizer(callback)
        +location(dbName)
    }

    class StatementSync {
        +String sourceSQL
        +String expandedSQL
        +all(params) Array
        +get(params) Object
        +run(params) Object
        +iterate(params) Iterator
        +columns() Array
        +setAllowBareNamedParameters(enabled)
        +setAllowUnknownNamedParameters(enabled)
        +setReadBigInts(enabled)
        +setReturnArrays(enabled)
    }

    class Session {
        +changeset() Uint8Array
        +patchset() Uint8Array
        +close()
    }

    class SQLTagStore {
        +Number size
        +Number capacity
        +DatabaseSync db
        +all() Array
        +get() Object
        +run() Object
        +iterate() Iterator
        +clear()
    }

    DatabaseSync "1" --> "*" StatementSync : prepare()
    DatabaseSync "1" --> "*" Session : createSession()
    DatabaseSync "1" --> "*" SQLTagStore : createTagStore()
```

## SQLiteデータ型マッピング

```mermaid
flowchart LR
    subgraph SQLite
        SQL_NULL[NULL]
        SQL_INTEGER[INTEGER]
        SQL_REAL[REAL]
        SQL_TEXT[TEXT]
        SQL_BLOB[BLOB]
    end

    subgraph JavaScript
        JS_NULL[null]
        JS_NUMBER[number]
        JS_BIGINT[bigint]
        JS_STRING[string]
        JS_TYPED_ARRAY[TypedArray]
        JS_DATA_VIEW[DataView]
    end

    SQL_NULL --> JS_NULL
    SQL_INTEGER --> JS_NUMBER
    SQL_INTEGER --> JS_BIGINT
    SQL_REAL --> JS_NUMBER
    SQL_TEXT --> JS_STRING
    SQL_BLOB --> JS_TYPED_ARRAY
    SQL_BLOB --> JS_DATA_VIEW
```

## 備考

- Web Storageスキーマは2つのテーブルと3つのトリガーで構成されるシンプルな設計です
- `nodejs_webstorage_state`はシングルトンテーブルとして設計されており、`CHECK(single_row_ = 1)`制約により常に1行のみ存在します
- トリガーによるクォータ管理はアトミックに行われ、容量超過時はトランザクションがロールバックされます
- `node:sqlite`モジュールは汎用的なSQLiteアクセスを提供するため、固定のスキーマを持ちません
