# バッチ設計書 1-vcbuild.bat

## 概要

本ドキュメントは、Node.jsプロジェクトのWindowsビルドバッチスクリプト「vcbuild.bat」の設計仕様を記載したものである。

### 本バッチの処理概要

vcbuild.batは、Windows環境においてNode.jsのビルド、テスト、パッケージング、署名、アップロードを統合的に実行するためのバッチスクリプトである。Visual Studioのビルドツールチェーンを使用し、MSBuildを介してプロジェクトをコンパイルする。

**業務上の目的・背景**：Node.jsはクロスプラットフォームで動作するJavaScriptランタイムであり、Windows環境での開発・配布を行うためには専用のビルドシステムが必要である。vcbuild.batは、Windows開発者がNode.jsをソースからビルドしたり、リリースビルドを作成したりする際の入口となるスクリプトであり、複雑なビルドオプションを単一のコマンドで制御できるようにすることで、ビルドプロセスの標準化と効率化を実現している。

**バッチの実行タイミング**：開発者による手動実行、またはCI/CDパイプライン（Windows環境）での自動実行。リリース時にはbuild-releaseオプションで完全なリリースビルドを作成する。

**主要な処理内容**：
1. コマンドライン引数の解析とビルドオプションの設定
2. Visual Studioビルド環境の検出と設定（VS2022/VS2026対応）
3. Python/NASMなどのビルド依存ツールの検出
4. configure.pyを呼び出してビルド設定を生成
5. MSBuildを使用したNode.jsのコンパイル
6. テストスイートの実行（cctest、test.py）
7. ネイティブアドオンのビルドとテスト
8. パッケージング（7z、zip形式）
9. MSIインストーラーの作成
10. コード署名とリリースファイルのアップロード
11. ドキュメントのビルド
12. リント処理（C++、JavaScript、Markdown）

**前後の処理との関連**：configure.pyと連携してビルド設定を生成し、tools/test.pyを呼び出してテストを実行する。リリースビルドではtools/sign.batでコード署名を行い、ステージングサーバーへアップロードする。

**影響範囲**：Windowsプラットフォームでのビルド成果物（node.exe、libnode.dll、MSIインストーラー、パッケージアーカイブ）の生成に影響を与える。

## バッチ種別

ビルド / テスト / パッケージング / リリース

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時）/ CI/CDパイプライン実行時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動実行 / CIジョブ |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Visual Studio | Visual Studio 2022または2026がインストールされていること |
| Python | Python 3がPATHに存在すること |
| NASM | x86/x64ビルド時、OpenSSLのアセンブリ最適化に必要（--openssl-no-asmで回避可能） |
| 7-Zip | パッケージング時に必要 |
| Git | ソースコードがgitリポジトリにある場合に使用 |

### 実行可否判定

- Visual Studioのインストール状況を確認し、見つからない場合はエラー終了
- 32ビット（x86）ビルドは非サポートのためエラー終了
- Node.js v24以降はClang-CLが必須

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| debug | フラグ | No | - | Debugビルドを実行 |
| release | フラグ | No | 有効 | Releaseビルドを実行（LTCG有効） |
| clean | フラグ | No | - | ビルド成果物をクリーン |
| x64 | フラグ | No | 有効 | 64ビットビルド |
| arm64 | フラグ | No | - | ARM64ビルド |
| vs2022 | フラグ | No | - | Visual Studio 2022を使用 |
| vs2026 | フラグ | No | - | Visual Studio 2026を使用 |
| clang-cl | フラグ | No | - | Clang-CLコンパイラを使用 |
| test | フラグ | No | - | テストを実行 |
| msi | フラグ | No | - | MSIインストーラーを作成 |
| package | フラグ | No | - | パッケージを作成 |
| build-release | フラグ | No | - | リリースビルドを作成 |
| sign | フラグ | No | - | 成果物にコード署名 |
| upload | フラグ | No | - | ステージングサーバーへアップロード |
| lint | フラグ | No | - | リント処理を実行 |
| doc | フラグ | No | - | ドキュメントをビルド |
| noprojgen | フラグ | No | - | プロジェクト生成をスキップ |
| nobuild | フラグ | No | - | ビルドをスキップ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースコード | ファイル | Node.jsソースコード一式 |
| node_version.h | ヘッダファイル | バージョン情報 |
| *.gyp/*.gypi | GYPファイル | ビルド設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| out/Release/node.exe | 実行ファイル | Node.js本体 |
| out/Release/node.lib | ライブラリ | リンク用ライブラリ |
| Release/*.7z | アーカイブ | 7z形式パッケージ |
| Release/*.zip | アーカイブ | ZIP形式パッケージ |
| node-v*.msi | インストーラー | MSIインストーラー |
| Release/license.rtf | ドキュメント | RTF形式ライセンス |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | node-v{VERSION}-win-{ARCH}.{ext} |
| 出力先 | Release/ |
| 文字コード | バイナリ |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析
   └─ コマンドライン引数を解析し、ビルドオプションを設定
2. 環境検出
   └─ Python、NASM、Visual Studioのパスを検出
3. バージョン取得
   └─ getnodeversion.pyを呼び出してNode.jsバージョンを取得
4. プロジェクト生成
   └─ configure.pyを実行してVisual Studioプロジェクトを生成
5. ビルド実行
   └─ MSBuildでnode.slnをビルド
6. 署名処理（オプション）
   └─ tools/sign.batでコード署名
7. ライセンスRTF生成（オプション）
   └─ license2rtf.mjsでLICENSEをRTF形式に変換
8. パッケージング（オプション）
   └─ 7zでアーカイブ作成
9. MSI作成（オプション）
   └─ WiXでMSIインストーラーを作成
10. アップロード（オプション）
    └─ SCPでステージングサーバーにアップロード
11. テスト実行（オプション）
    └─ cctest、test.pyを実行
12. リント実行（オプション）
    └─ C++、JS、MDのリント処理
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[環境検出]
    C --> D{VS検出成功?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[バージョン取得]
    F --> G{noprojgen?}
    G -->|No| H[configure.py実行]
    G -->|Yes| I{nobuild?}
    H --> I
    I -->|No| J[MSBuildでビルド]
    I -->|Yes| K[後処理へ]
    J --> K
    K --> L{sign指定?}
    L -->|Yes| M[コード署名]
    L -->|No| N{package指定?}
    M --> N
    N -->|Yes| O[パッケージング]
    N -->|No| P{test指定?}
    O --> P
    P -->|Yes| Q[テスト実行]
    P -->|No| R[バッチ終了]
    Q --> R
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 無効なコマンドライン引数 | ヘルプを参照して正しい引数を指定 |
| 1 | 環境エラー | Visual Studioが見つからない | VS2022/2026をインストール |
| 1 | ビルドエラー | MSBuildが失敗 | エラーメッセージを確認して修正 |
| 1 | 署名エラー | 署名処理が失敗 | 証明書の設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | N/A |
| リトライ対象エラー | なし |

### 障害時対応

- ビルドエラー発生時は`vcbuild projgen`でプロジェクトファイルを再生成
- テストクリーンは`vcbuild testclean`で実行可能
- 完全クリーンは`vcbuild clean`で実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のビルド |
| 目標処理時間 | 環境依存（通常15-60分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ディレクトリでの複数同時実行は非推奨。ビルド成果物が競合する可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各処理ステップ | 処理内容の説明 |
| ビルドログ | ビルド中 | MSBuildの出力 |
| テストログ | テスト実行時 | テスト結果（test.tap） |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDシステム |

## 備考

- Node.js v24以降ではClang-CLの使用が必須となる
- Visual Studio 17.10には既知のビルド問題があり、使用不可
- ARM64クロスコンパイル時は自動でx64のNode.exeをダウンロードしてlicense2rtfを実行
