# バッチ設計書 12-merge.sh

## 概要

本ドキュメントは、Node.jsプロジェクトのGitHub Actionsで使用されるマージスクリプト（merge.sh）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Node.jsプロジェクトにおけるPull Request（PR）の「パープルマージ」（Squash and Merge）を実行するスクリプトである。単一コミットとしてランディングすべきPRを、GitHubのSquash and Merge機能を使用してマージする。`git node land --fixupAll`で準備されたコミットを、GitHub APIを通じてスカッシュマージすることで、コミット履歴をクリーンに保つ。

**業務上の目的・背景**：Node.jsプロジェクトでは、PRを単一の意味のあるコミットとしてマージすることが求められるケースがある。手動でスカッシュマージを行う場合、コミットメッセージの整形やPR-URLトレーラーの正確な設定が煩雑になる。本バッチにより、一貫性のあるスカッシュマージ処理を自動化し、正確なコミット履歴を維持する。

**バッチの実行タイミング**：メンテナーが手動で実行する。`git node land --fixupAll`実行後、コミットハッシュを確認した上で本スクリプトを呼び出す。

**主要な処理内容**：
1. PR番号とコミットハッシュの入力検証
2. PR-URLトレーラーの整合性確認
3. 複数コミットマージの拒否（単一コミット限定）
4. GitHub APIを使用したSquash and Mergeの実行
5. マージ成功時のコメント投稿

**前後の処理との関連**：`git node land --fixupAll`コマンドで事前準備が必要。マージ完了後は通常のリリースプロセスに組み込まれる。

**影響範囲**：対象PRのマージ状態、mainブランチへのコード統合、PRコメントの追加に影響を与える。

## バッチ種別

CI/CD自動化（Pull Requestスカッシュマージ処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 任意 |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | 手動（コマンドライン実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub CLI（gh）のインストール | PR操作・API呼び出しに必要 |
| jqコマンドのインストール | JSONデータの構築に必要 |
| gitコマンドのインストール | コミット情報の取得に必要 |
| grepコマンドのインストール | パターンマッチングに必要 |
| awkコマンドのインストール | URL解析に使用（URL入力時） |
| git node land --fixupAll 実行済み | 事前にコミットが準備されている必要がある |
| GITHUB_TOKEN環境変数 | GitHub API認証用 |

### 実行可否判定

1. PR番号が数値形式であること
2. コミットハッシュが40文字の16進数であること
3. 現在のHEADコミットにPR-URLトレーラーが含まれていること
4. HEAD^コミットに同じPR-URLトレーラーが含まれていないこと（複数コミット拒否）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| pr | string | Yes | - | PR番号またはPR URL（第1引数） |
| commit_head | string | Yes | - | PRブランチのコミットハッシュ（第2引数、URL形式の場合は省略可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | string | PR番号/URL、コミットハッシュ |
| Gitリポジトリ | - | HEADコミットのメッセージ・タイトル |
| GitHub API | JSON | PRマージAPI |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub PR | コメント | マージ完了コメント（コミットSHA） |
| 標準出力 | テキスト | 処理ログ・エラーメッセージ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. 入力パラメータの解析
   └─ URLからPR番号とコミットハッシュを抽出（URL形式の場合）
2. 入力検証
   └─ PR番号が数値であることを確認
   └─ コミットハッシュが40文字16進数であることを確認
3. PR-URLトレーラーの検証
   └─ HEADコミットにPR-URLが含まれることを確認
   └─ HEAD^コミットに同じPR-URLが含まれていないことを確認
4. コミット情報の取得
   └─ コミットタイトル・ボディを取得
5. GitHub APIでSquash and Merge実行
   └─ PUT /repos/{owner}/{repo}/pulls/{pr}/merge
6. マージ結果のコメント投稿
   └─ "Landed in {commitSHA}"
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{URL形式?}
    B -->|はい| C[URLからPR番号・ハッシュ抽出]
    B -->|いいえ| D[引数をそのまま使用]
    C --> E[入力検証]
    D --> E
    E --> F{PR番号が有効?}
    F -->|いいえ| G[エラー終了]
    F -->|はい| H{コミットハッシュが有効?}
    H -->|いいえ| G
    H -->|はい| I[HEAD PR-URLトレーラー確認]
    I --> J{PR-URL存在?}
    J -->|いいえ| K[Invalid PR-URL trailer エラー]
    J -->|はい| L[HEAD^ PR-URLトレーラー確認]
    L --> M{HEAD^にも同じPR-URL?}
    M -->|はい| N[複数コミット拒否エラー]
    M -->|いいえ| O[コミット情報取得]
    O --> P[GitHub API Squash Merge]
    P --> Q{マージ成功?}
    Q -->|はい| R[コメント投稿]
    Q -->|いいえ| S[エラー終了]
    R --> T[バッチ終了]
    K --> G
    N --> G
    S --> G
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを直接操作しない。GitHub APIを通じたPR状態の更新が主な操作となる。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| マージ実行 | GitHub PR | UPDATE | Squash and Mergeでマージ |
| コメント投稿 | GitHub PR | INSERT | マージ完了コメント追加 |

### テーブル別操作詳細

N/A（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 入力検証エラー | PR番号が無効 | 使用方法を表示して終了 |
| 1 | 入力検証エラー | コミットハッシュが無効 | 使用方法を表示して終了 |
| 1 | PR-URLエラー | PR-URLトレーラーが不正 | エラーメッセージ表示して終了 |
| 1 | 複数コミットエラー | 複数コミットのマージを試行 | 拒否メッセージ表示して終了 |
| - | APIエラー | GitHub API呼び出し失敗 | スクリプト終了（set -eによる） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（即時失敗） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認
2. 入力パラメータの形式を確認
3. `git node land --fixupAll`が正しく実行されたか確認
4. PR-URLトレーラーが正しく設定されているか確認
5. GitHub API権限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 単一PR |
| コミットタイミング | GitHub APIマージ完了時 |
| ロールバック条件 | N/A（API失敗時は自動ロールバック） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 PR/実行 |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 標準シェル環境 |

## 排他制御

- 同一PRに対する同時マージ操作はGitHub APIレベルで排他制御される
- コミットハッシュの検証により、古い状態でのマージを防止

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | コマンド実行時 | 実行中のコマンド（set -x） |
| 入力ログ | パラメータ解析時 | PR番号、コミットハッシュ |
| エラーログ | 検証失敗時 | エラー種別・詳細 |
| 成功ログ | マージ完了時 | マージコミットSHA |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60秒 | 標準出力 |
| エラー発生 | 1件以上 | 標準エラー出力 |

## 備考

- 「パープルマージ」とは、GitHubのSquash and Merge機能を使用したマージを指す（マージコミットのアイコンが紫色のため）
- デフォルトのリポジトリはnodejs/nodeだが、URL形式で他のリポジトリも指定可能
- git interpret-trailersを使用してPR-URLトレーラーを解析
- 入力形式は以下の3種類をサポート：
  1. `merge.sh 12345 aaaaabbbbbcccccdddddeeeeefffff1111122222`
  2. `merge.sh https://github.com/nodejs/node/pull/12345 aaaaabbbbb...`
  3. `merge.sh https://github.com/nodejs/node/pull/12345/commits/aaaaabbbbb...`
