# バッチ設計書 13-rebase.sh

## 概要

本ドキュメントは、Node.jsプロジェクトのGitHub Actionsで使用されるリベーススクリプト（rebase.sh）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Pull Request（PR）のブランチをベースブランチに対してリベースするスクリプトである。GitHub GraphQL APIを使用して、PRブランチを最新のベースブランチにリベース（更新）する。これにより、コンフリクトの早期検出やCIの再実行を促進する。

**業務上の目的・背景**：大規模なオープンソースプロジェクトでは、PRがベースブランチから乖離することがよくある。この乖離が大きくなると、マージ時のコンフリクトが発生しやすくなり、CIの結果も古い状態のままになる。本バッチにより、PRブランチを最新状態に更新し、コンフリクトを早期に検出することで、マージプロセスを円滑にする。

**バッチの実行タイミング**：GitHub Actionsのイベント（リベースリクエストラベル付与時など）または手動で実行される。

**主要な処理内容**：
1. PR IDの取得（GitHub CLI使用）
2. GitHub GraphQL APIのupdatePullRequestBranch mutationを実行
3. REBASEメソッドでブランチを更新

**前後の処理との関連**：リベース後は通常CIが再実行される。commit-queue処理の前提条件として、ブランチが最新であることが求められる場合がある。

**影響範囲**：対象PRのブランチ履歴、コミットハッシュが変更される。CIの再実行がトリガーされる。

## バッチ種別

CI/CD自動化（Pull Requestリベース処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動 / 手動 |
| 実行時刻 | 随時 |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | GitHub Actions / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub CLI（gh）のインストール | PR情報取得・API呼び出しに必要 |
| GITHUB_TOKEN環境変数 | GitHub API認証用 |
| PRが存在すること | 有効なPR番号またはURLが必要 |
| リベース可能な状態 | コンフリクトがない状態 |

### 実行可否判定

1. 指定されたPRが存在すること
2. PRがオープン状態であること
3. リベースが可能な状態であること（コンフリクトなし）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PR識別子 | string | Yes | - | PR番号またはURL（第1引数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | string | PR番号またはURL |
| GitHub API | JSON | PR ID情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | JSON | GraphQL APIの実行結果 |
| GitHub PR | ブランチ更新 | リベースされたブランチ |

### 出力ファイル仕様

本バッチはファイル出力を行わない。

## 処理フロー

### 処理シーケンス

```
1. PR IDの取得
   └─ gh pr view コマンドでPRのGraphQL IDを取得
2. GraphQL mutation実行
   └─ updatePullRequestBranch mutationを呼び出し
   └─ updateMethod: REBASEを指定
3. 結果の出力
   └─ clientMutationIdを返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[PR ID取得]
    B --> C{PR存在?}
    C -->|いいえ| D[空文字でAPI呼び出し]
    C -->|はい| E[PR IDを取得]
    D --> F[GraphQL mutation実行]
    E --> F
    F --> G[updatePullRequestBranch]
    G --> H{成功?}
    H -->|はい| I[clientMutationId返却]
    H -->|いいえ| J[エラー終了]
    I --> K[バッチ終了]
    J --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを直接操作しない。GitHub GraphQL APIを通じたPRブランチの更新が主な操作となる。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リベース実行 | GitHub PR ブランチ | UPDATE | ブランチをベースブランチにリベース |

### テーブル別操作詳細

N/A（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | PR不存在 | 指定されたPRが見つからない | PR番号を確認して再実行 |
| - | コンフリクト | リベース時にコンフリクト発生 | 手動でコンフリクト解消 |
| - | 権限エラー | API権限不足 | GITHUB_TOKEN権限を確認 |
| - | APIエラー | GraphQL API失敗 | ネットワーク・API状態を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（即時失敗） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認
2. PRが存在し、オープン状態であることを確認
3. コンフリクトがないことを確認
4. GITHUB_TOKEN権限を確認
5. 必要に応じて手動でリベース実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 単一PR |
| コミットタイミング | GraphQL mutation完了時 |
| ロールバック条件 | N/A（失敗時は変更なし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 PR/実行 |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 標準シェル環境 |

## 排他制御

- 同一PRに対する同時リベース操作はGitHub APIレベルで排他制御される
- 他のブランチ操作（プッシュ等）との競合はGitHub側で管理

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | コマンド実行時 | 実行中のコマンド（set -x） |
| 結果ログ | API完了時 | GraphQLレスポンス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60秒 | GitHub Actions |
| エラー発生 | 1件以上 | 標準エラー出力 |

## 備考

- 非常にシンプルなスクリプト（11行）
- `|| true`によりPR取得失敗時もスクリプトは継続する
- GraphQL mutationのupdatePullRequestBranchを使用
- updateMethod: REBASEでリベース方式を指定（MERGEも選択可能）
- `set -xe`オプションにより、コマンドの実行内容が表示され、エラー発生時は即座に終了する
