# バッチ設計書 14-start-ci.sh

## 概要

本ドキュメントは、Node.jsプロジェクトのGitHub Actionsで使用されるCI開始スクリプト（start-ci.sh）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Pull Request（PR）に対してCIジョブを開始するスクリプトである。`request-ci`ラベルが付与されたPRを検出し、`ncu-ci run`コマンドを使用してCI実行を開始する。CI開始に失敗した場合は、`request-ci-failed`ラベルを付与し、エラー詳細をPRコメントとして投稿する。

**業務上の目的・背景**：Node.jsプロジェクトでは、PRに対してJenkins CI等の外部CIシステムでテストを実行する必要がある。CIの手動起動は煩雑であり、起動忘れによるレビュー遅延が発生する。本バッチにより、`request-ci`ラベル付与をトリガーとしてCIを自動開始し、CI実行プロセスを効率化する。

**バッチの実行タイミング**：GitHub Actionsのイベント駆動で実行される。`request-ci`ラベルがPRに付与されたタイミングで起動する。

**主要な処理内容**：
1. 対象PRから`request-ci`ラベルを削除
2. `ncu-ci run`コマンドでCI実行を開始
3. CI開始成功時は処理完了
4. CI開始失敗時は`request-ci-failed`ラベル付与とエラーコメント投稿

**前後の処理との関連**：CIが完了すると、commit-queue.shによる自動マージ処理が可能になる。

**影響範囲**：PRのラベル状態、外部CIシステム（Jenkins等）のジョブ起動に影響を与える。

## バッチ種別

CI/CD自動化（CIジョブ起動処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動 |
| 実行時刻 | 随時（ラベル付与時） |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | GitHub Actions（request-ciラベル付与イベント） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub CLI（gh）のインストール | ラベル操作・コメント投稿に必要 |
| ncu-ciコマンドのインストール | CI実行開始に必要 |
| GITHUB_TOKEN環境変数 | GitHub API認証用 |
| 外部CIシステムへのアクセス権限 | Jenkins等へのジョブ起動権限 |

### 実行可否判定

1. PRに`request-ci`ラベルが付与されていること
2. PRが有効な状態であること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PR番号リスト | string[] | Yes | - | 処理対象のPR番号（引数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | string | PR番号のリスト |
| 環境変数 | string | GITHUB_SERVER_URL, GITHUB_REPOSITORY, GITHUB_RUN_ID |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub PR | ラベル | request-ciラベルの削除、失敗時はrequest-ci-failedラベル付与 |
| GitHub PR | コメント | CI開始失敗時のエラーコメント |
| 標準出力 | テキスト | 処理ログ |
| outputファイル | テキスト | ncu-ciコマンドの出力（一時ファイル） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | output |
| 出力先 | カレントディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 各PRに対してループ処理開始
   └─ 引数で渡されたPR番号を順次処理
2. request-ciラベルの削除
   └─ gh pr edit --remove-label
3. ncu-ci runコマンドの実行
   └─ CI開始処理を実行し、結果をoutputファイルに記録
4. 結果判定
   └─ 成功: 処理完了
   └─ 失敗: request-ci-failedラベル付与
5. 失敗時の後処理
   └─ エラーコメントをPRに投稿
   └─ GitHub ActionsのURLを含める
6. 一時ファイルの削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[PRループ開始]
    B --> C[request-ciラベル削除]
    C --> D[outputファイル削除]
    D --> E[ncu-ci run実行]
    E --> F{CI開始成功?}
    F -->|はい| G[処理完了]
    F -->|いいえ| H[request-ci-failedラベル付与]
    H --> I[エラーコメント作成]
    I --> J[PRにコメント投稿]
    J --> K[outputファイル削除]
    G --> L{残りPRあり?}
    K --> L
    L -->|はい| B
    L -->|いいえ| M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを直接操作しない。GitHub APIを通じたPR状態の更新と外部CIシステムへのジョブ起動が主な操作となる。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ラベル削除 | GitHub PR | UPDATE | request-ciラベルの削除 |
| ラベル付与 | GitHub PR | UPDATE | request-ci-failedラベルの付与（失敗時） |
| コメント投稿 | GitHub PR | INSERT | エラーコメントの追加（失敗時） |
| CI起動 | 外部CI | EXECUTE | Jenkins等のジョブ起動 |

### テーブル別操作詳細

N/A（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CI開始失敗 | ncu-ci runコマンドの失敗 | request-ci-failedラベル付与、エラーコメント投稿 |
| - | API失敗 | GitHub API呼び出し失敗 | スクリプト継続（set -eなし） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（即時失敗） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. `request-ci-failed`ラベルがPRに付与される
2. エラー詳細がPRコメントとして投稿される
3. GitHub Actionsの実行URLがコメントに含まれる
4. 手動でCI起動を試行するか、原因を調査

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | PR単位 |
| コミットタイミング | 各PR処理完了時 |
| ロールバック条件 | N/A（部分的な失敗を許容） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1〜5 PR/実行 |
| 目標処理時間 | 1分以内/PR |
| メモリ使用量上限 | GitHub Actions標準リソース |

## 排他制御

- `request-ci`ラベル削除により、同じPRに対する重複処理を防止
- 複数のGitHub Actions実行が同時に同じPRを処理しない

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | コマンド実行時 | 実行中のコマンド（set -x） |
| CI出力ログ | ncu-ci実行後 | ncu-ciコマンドの出力 |
| エラーログ | CI開始失敗時 | エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5分/PR | GitHub Actions |
| エラー発生 | 1件以上 | PRコメント |

## 備考

- `set -xe`オプションにより、コマンドの実行内容が表示され、エラー発生時は即座に終了する
- `ncu-ci`はNode.js Commit Queue CIツールで、Jenkins等の外部CIシステムを起動する
- 環境変数`GITHUB_SERVER_URL`、`GITHUB_REPOSITORY`、`GITHUB_RUN_ID`はGitHub Actionsから自動的に提供される
- エラーコメントはHTML形式（detailsタグ）で整形される
- 複数PRを一度に処理可能（forループで順次処理）
