# バッチ設計書 15-review_backport.sh

## 概要

本ドキュメントは、Node.jsプロジェクトのGitHub Actionsで使用されるバックポートレビュースクリプト（review_backport.sh）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、バックポートPull Request（PR）のレビューを支援するスクリプトである。オリジナルのPRとバックポートPRの差分を比較し、バックポートが正しく行われているかを確認する。インデックス情報や行番号情報を正規化した上で差分比較を行うことで、本質的な変更のみを抽出する。

**業務上の目的・背景**：Node.jsプロジェクトでは、セキュリティ修正やバグ修正を過去のリリースブランチにバックポートする必要がある。バックポートPRのレビューは、オリジナルの変更が正しく適用されているかを確認する作業であり、手作業では見落としが発生しやすい。本バッチにより、オリジナルとバックポートの差分を自動比較し、レビュー作業を効率化する。

**バッチの実行タイミング**：メンテナーが手動で実行する。バックポートPRのレビュー時に使用する。

**主要な処理内容**：
1. バックポートPRからコミット情報とオリジナルPR URLを抽出
2. オリジナルPRとバックポートPRの差分ファイルを取得
3. インデックス情報と行番号情報を正規化（sed処理）
4. 正規化後の差分を比較（diff）
5. 差分結果を出力または外部diffツールで表示

**前後の処理との関連**：commit-queue-squashラベルでランディングされたPRのバックポートに使用される。レビュー完了後は通常のマージ処理に移行する。

**影響範囲**：差分比較結果の表示のみで、リポジトリやPRの状態には影響を与えない。

## バッチ種別

CI/CD自動化（バックポートレビュー支援）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 任意 |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | 手動（コマンドライン実行） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub CLI（gh）のインストール | PR情報取得に必要 |
| curlコマンドのインストール | 差分ファイルのダウンロードに必要 |
| sedコマンドのインストール | 差分の正規化に必要 |
| diffコマンドのインストール | 差分比較に必要（デフォルト） |
| mktempコマンドのインストール | 一時ファイル作成に必要 |
| GITHUB_TOKEN環境変数（推奨） | GitHub API認証用 |

### 実行可否判定

1. バックポートPRのURLが指定されていること
2. バックポートPRがcommit-queue-squashでランディングされたPRであること
3. コミットメッセージにPR-URLトレーラーが含まれていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BACKPORT_PR | string | Yes | - | バックポートPRのURL（第1引数） |
| DIFF_CMD | string | No | diff | 差分比較コマンド（環境変数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | string | バックポートPR URL |
| 環境変数 | string | DIFF_CMD（オプション） |
| GitHub API | JSON | PRのコミット情報 |
| GitHub差分ファイル | diff | .diff形式のパッチファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | diff | オリジナルとバックポートの差分比較結果 |
| 外部diffツール | - | DIFF_CMD指定時はそのツールで表示 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 一時ファイル（mktemp） |
| 出力先 | システム一時ディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ バックポートPR URLが指定されているか確認
2. 一時ファイルの作成
   └─ ORIGINAL: オリジナルPR差分用
   └─ BACKPORT: バックポートPR差分用
3. コミット情報の取得
   └─ gh pr viewでコミットSHAとPR-URL抽出
4. 各コミットに対してループ処理
   └─ コミットSHAとPR URLを分離
5. オリジナルPR差分の取得
   └─ curl -fsL "$PR_URL.diff"
   └─ sedで正規化してORIGINALファイルに追記
6. バックポートPR差分の取得
   └─ curl -fsL "$BACKPORT_PR/commits/$COMMIT_SHA.diff"
   └─ sedで正規化してBACKPORTファイルに追記
7. 差分比較の実行
   └─ DIFF_CMD（デフォルト:diff）で比較
8. 一時ファイルの削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{BACKPORT_PR指定?}
    B -->|いいえ| C[使用方法表示]
    C --> D[終了 exit 1]
    B -->|はい| E[一時ファイル作成]
    E --> F[PRコミット情報取得]
    F --> G[コミットループ開始]
    G --> H[コミットSHA抽出]
    H --> I[PR URL抽出]
    I --> J[オリジナルPR差分取得]
    J --> K[sed正規化してORIGINALに追記]
    K --> L[バックポートPR差分取得]
    L --> M[sed正規化してBACKPORTに追記]
    M --> N{残りコミット?}
    N -->|はい| G
    N -->|いいえ| O[DIFF_CMD実行]
    O --> P[一時ファイル削除]
    P --> Q[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを操作しない。読み取り専用の差分比較ツールである。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 差分取得 | GitHub | SELECT | PR差分ファイルのダウンロード |

### テーブル別操作詳細

N/A（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | BACKPORT_PRが未指定 | 使用方法を表示して終了 |
| - | 差分取得失敗 | curl -fオプションによる失敗 | スクリプト終了（set -e） |
| - | PR情報取得失敗 | ghコマンド失敗 | スクリプト終了（set -e） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（即時失敗） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認
2. バックポートPRのURLが正しいことを確認
3. PRがcommit-queue-squashでランディングされた形式であることを確認
4. ネットワーク接続を確認
5. GITHUB_TOKEN権限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 PR/実行 |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 標準シェル環境 |

## 排他制御

- 排他制御なし（読み取り専用処理）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | コマンド実行時 | 実行中のコマンド（set -x） |
| 差分出力 | 処理完了時 | オリジナルとバックポートの差分 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60秒 | 標準出力 |

## 備考

- 制限事項：単一コミットとしてランディングされたPR（commit-queue-squashラベル使用）のみサポート
- sedコマンドで以下の正規化を実行：
  - `index`行のハッシュ部分を`eeeeeeeeee..eeeeeeeeee`に置換
  - `@@`行（ハンク情報）を`@@ -111,1 +111,1 @@`に置換
- DIFF_CMD環境変数で外部diffツールを指定可能（例：`codium --wait --diff`）
- 使用例：
  - 標準出力：`tools/actions/review_backport.sh https://github.com/nodejs/node/pull/12345 | less`
  - VSCode：`DIFF_CMD="codium --wait --diff" tools/actions/review_backport.sh https://github.com/nodejs/node/pull/12345`
- jqを使用してPR-URLをコミットメッセージから正規表現で抽出
