# バッチ設計書 16-create-release-proposal.sh

## 概要

本ドキュメントは、Node.jsプロジェクトのGitHub Actionsで使用されるリリース提案作成スクリプト（create-release-proposal.sh）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Node.jsの新しいリリース候補のPull Request（PR）を自動作成するスクリプトである。`git node release --prepare`コマンドでリリースコミットを準備し、GitHub APIを使用してプロポーザルブランチとドラフトPRを作成する。チェンジログからPR本文を生成し、適切なラベルとアサイニーを設定する。

**業務上の目的・背景**：Node.jsのリリースプロセスは複雑で多くの手順を含む。リリースPRの作成は定型作業であり、手動で行うとミスや漏れが発生しやすい。本バッチにより、リリースプロポーザルPRの作成を自動化し、リリースプロセスの効率化と品質向上を実現する。

**バッチの実行タイミング**：GitHub Actionsによるスケジュール実行または手動トリガーで実行される。リリースサイクルに合わせて週次または必要に応じて実行する。

**主要な処理内容**：
1. `git node release --prepare`でリリースコミットを準備
2. GitHub APIでプロポーザルブランチを作成
3. GitHub APIでドラフトPRを作成
4. GraphQL APIでリリースコミットをプッシュ
5. PRにラベル（release, v{LINE}.x）とアサイニーを設定

**前後の処理との関連**：リリーサーによるPRレビュー・修正後、リリース署名スクリプト（release.sh）に引き継がれる。

**影響範囲**：リリースブランチへの新規ブランチ作成、ドラフトPRの作成、チェンジログファイルの更新に影響を与える。

## バッチ種別

CI/CD自動化（リリースプロセス自動化）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 週次 / 随時 |
| 実行時刻 | スケジュール設定による |
| 実行曜日 | 設定による |
| 実行日 | 設定による |
| トリガー | GitHub Actions（スケジュール / 手動） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| node / npmのインストール | リリースコミット準備に必要 |
| GitHub CLI（gh）のインストール | API呼び出しに必要 |
| git / git-nodeのインストール | リリースコミット準備に必要 |
| awkコマンドのインストール | チェンジログ解析に必要 |
| GITHUB_REPOSITORY環境変数 | リポジトリ指定 |
| BOT_TOKEN環境変数 | GitHub API認証用（書き込み権限必須） |

### 実行可否判定

1. RELEASE_DATE（リリース日）が指定されていること
2. RELEASE_LINE（リリースライン）が指定されていること
3. GITHUB_REPOSITORYとBOT_TOKENが設定されていること
4. 必要な依存コマンドがインストールされていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| RELEASE_DATE | string | Yes | - | リリース日（第1引数） |
| RELEASE_LINE | string | Yes | - | リリースライン（第2引数、例：20, 21） |
| RELEASER | string | No | - | リリーサーのGitHubユーザー名（第3引数） |
| GITHUB_REPOSITORY | string | Yes | nodejs/node | 環境変数 |
| BOT_TOKEN | string | Yes | - | 環境変数（GitHub API認証） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| コマンドライン引数 | string | リリース日、リリースライン、リリーサー |
| 環境変数 | string | GITHUB_REPOSITORY, BOT_TOKEN |
| チェンジログファイル | Markdown | doc/changelogs/CHANGELOG_V{LINE}.md |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub | ブランチ | プロポーザルブランチ（v{LINE}.x-proposal） |
| GitHub | PR | ドラフトPR |
| 標準出力 | テキスト | 処理ログ、PR URL |

### 出力ファイル仕様

本バッチはローカルファイルを直接出力しない。GitHubリポジトリにリリースコミットをプッシュする。

## 処理フロー

### 処理シーケンス

```
1. 入力検証
   └─ RELEASE_DATE, RELEASE_LINEの必須チェック
   └─ GITHUB_REPOSITORY, BOT_TOKENの必須チェック
2. 依存コマンドの確認
   └─ node, gh, git, git-node, awkの存在確認
3. リリースコミットの準備
   └─ git node release --prepare --skipBranchDiff --yes
4. ブランチ・コミット情報の取得
   └─ HEAD_BRANCH, HEAD_SHA, TITLEを取得
5. PR本文の生成
   └─ チェンジログから該当セクションを抽出
6. プロポーザルブランチの作成
   └─ GitHub REST API POST /repos/.../git/refs
7. ドラフトPRの作成
   └─ GitHub REST API POST /repos/.../pulls
8. リリースコミットのプッシュ
   └─ GitHub GraphQL API createCommitOnBranch
9. PRのラベル・アサイニー設定
   └─ gh pr edit --add-label --add-assignee
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|NG| C[エラー終了]
    B -->|OK| D{環境変数チェック}
    D -->|NG| C
    D -->|OK| E[依存コマンド確認]
    E --> F{全て存在?}
    F -->|NG| C
    F -->|OK| G[git node release --prepare]
    G --> H[ブランチ・コミット情報取得]
    H --> I[チェンジログからPR本文生成]
    I --> J[プロポーザルブランチ作成]
    J --> K[ドラフトPR作成]
    K --> L[GraphQLでコミットプッシュ]
    L --> M[ラベル・アサイニー設定]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを直接操作しない。GitHub APIを通じたリポジトリ操作が主な処理となる。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ブランチ作成 | GitHub | INSERT | プロポーザルブランチの作成 |
| PR作成 | GitHub | INSERT | ドラフトPRの作成 |
| コミットプッシュ | GitHub | INSERT | リリースコミットのプッシュ |
| ラベル付与 | GitHub PR | UPDATE | release, v{LINE}.xラベルの付与 |
| アサイニー設定 | GitHub PR | UPDATE | リリーサーをアサイン |

### テーブル別操作詳細

N/A（データベース操作なし）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | RELEASE_DATEまたはRELEASE_LINEが未指定 | 使用方法を確認して再実行 |
| 1 | 環境変数エラー | GITHUB_REPOSITORYまたはBOT_TOKENが未設定 | 環境変数を設定して再実行 |
| 1 | 依存コマンドエラー | 必要なコマンドがインストールされていない | 依存コマンドをインストール |
| - | APIエラー | GitHub API呼び出し失敗 | ネットワーク・権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（即時失敗） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. エラーメッセージを確認
2. 引数・環境変数が正しく設定されているか確認
3. 依存コマンドがインストールされているか確認
4. BOT_TOKEN権限を確認（repo権限必須）
5. 既に同名ブランチが存在しないか確認
6. 手動でリリースプロセスを実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 全体（ただしロールバック不可） |
| コミットタイミング | 各API呼び出し完了時 |
| ロールバック条件 | N/A（部分的な作成は手動削除が必要） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1リリース/実行 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | GitHub Actions標準リソース |

## 排他制御

- 同一リリースラインに対する同時実行は想定しない
- 既存ブランチ名との衝突はAPI側でエラーとなる

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 実行ログ | コマンド実行時 | 実行中のコマンド（set -x） |
| API結果ログ | API完了時 | APIレスポンス |
| PR URLログ | PR作成完了時 | 作成されたPRのURL |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 10分 | GitHub Actions |
| エラー発生 | 1件以上 | GitHub Actionsログ |

## 備考

- `set -xe`オプションにより、コマンドの実行内容が表示され、エラー発生時は即座に終了する
- PR本文は最大65536文字に制限（MAX_BODY_LENGTH）
- チェンジログが長すぎる場合は「...」で省略
- GraphQL APIを使用してファイル変更をプッシュ（createCommitOnBranch mutation）
- 変更ファイルはbase64エンコードしてアップロード
- 削除ファイルも対応（git show --diff-filter=D）
- PR-URLトレーラーは作成されたPRのURLで置換される
- ドラフトPRとして作成（draft=true）
- ベースブランチはv{LINE}.x形式
